<?php
    $appData = [
        'vendor' => 'Safineia GmbH',
        'environment' => 'Testserver 10.100.0.134',
        'appname' => 'SAFweb2',
        'release' => '2.1.16',
        'systemdb' => 'PostgreSQL 18.0',
        'pgadmin' => '4.8',
        'server-os' => 'Debian 12',
        'php-version' => '8.4',
        'oraapi' => '0.1.12',
        'odbcapi' => '-.-.-',
        'core' => '0.1.1',
        'mis.sivas' => '0.1.1',
        'neo.sivas' => '0.1.1'
    ];

    $customData = include __DIR__.'/data.php';

    function out($key, $section = 'appData') {
        global $appData, $customData;

        echo ${$section}[$key];
    }

    include_once './inc/head.php';
?>
    <div class="antialiased bg-gray-50 dark:bg-gray-900">
<?php
        include_once './inc/nav.php';
?>

        <main id="mainContainer" class="p-4 m-4 _md:ml-64 h-screen pt-20">

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
                <div class="_border-2 _border-dashed rounded-lg _border-gray-300 dark:_border-gray-600 h-32 md:h-64">
                    <!-- SAFweb2 PRODUCTION -->
                    <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                        <header class="flex p-3 items-center _bg-gray-200">
                            <div class="font-semibold">
                                <i class="fa fa-industry fa-2x"></i>
                            </div>
                            <div class="w-full">
                                    <span class="font-semibold ml-3 text-ctrl-green text-2xl">
                                        <a href="<?php out('APP_PROD_URL', 'customData') ?>"><?php out('appname') ?></a>
                                    </span>
                                <p class="ml-3 font-bold">Produktivumgebung</p>
                                <?php if ($customData['APP_PROD_ACTIVE'] == true): ?>
                                    <p class="ml-3 font-bold text-green-400">aktiv</p>
                                <?php else: ?>
                                    <p class="ml-3 font-bold text-red-400">nicht aktiv</p>
                                <?php endif; ?>

                            </div>
                        </header>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <a class="" href="<?php out('APP_PROD_URL', 'customData') ?>">
                                <div class="flex gap-3">
                                    <div><i class="fa fa-columns fa-1_5x text-xl"></i></div>
                                    <div class="flex flex-col">
                                        <div class="text-blue-500"><?php out('appname') ?> App</div>
                                        <description class="text-gray-400 text-sm">
                                            Die App für den täglichen Gebrauch
                                        </description>
                                    </div>
                                </div>
                            </a>
                        </content>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <a href="<?php out('PGADMIN_PROD_URL', 'customData') ?>">
                                <div class="flex gap-3">
                                    <div><i class="fa fa-database fa-1_5x text-xl"></i></div>
                                    <div class="flex flex-col">
                                        <div class="text-blue-500">pgadmin</div>
                                        <description class="text-gray-400 text-sm">
                                            Datenbankverwaltung
                                        </description>
                                    </div>
                                </div>
                            </a>
                        </content>
                    </card>
                </div>


                <div class="_border-2 _border-dashed rounded-lg _border-gray-300 dark:_border-gray-600 h-32 md:h-64">

                    <!-- SAFweb2 TEST -->
                    <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                        <header class="flex p-3 items-center">
                            <div class="font-semibold">
                                <i class="fa fa-wrench fa-2x text-gray-400"></i>
                            </div>
                            <div class="w-full">
                                <span class="font-semibold ml-3 text-ctrl-orange text-2xl">
                                    <a href="<?php out('APP_TEST_URL', 'customData') ?>"><?php out('appname') ?> Test</a>
                                </span>
                                <p class="ml-3">Testumgebung</p>
                                <?php if ($customData['APP_TEST_ACTIVE'] == true): ?>
                                    <p class="ml-3 font-bold text-green-400">aktiv</p>
                                <?php else: ?>
                                    <p class="ml-3 font-bold text-red-400">nicht aktiv</p>
                                <?php endif; ?>

                            </div>
                        </header>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <a href="<?php out('APP_TEST_URL', 'customData') ?>">
                                <div class="flex gap-3">
                                    <div><i class="fa fa-table fa-1_5x text-xl"></i></div>
                                    <div class="flex flex-col">
                                        <div class="text-blue-500"><?php out('appname') ?> App</div>
                                        <description class="text-gray-400 text-sm">
                                            Die App mit neuen Funktionen zum testen
                                        </description>
                                    </div>
                                </div>
                            </a>
                        </content>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <a href="<?php out('PGADMIN_TEST_URL', 'customData') ?>">
                                <div class="flex gap-3">
                                    <div><i class="fa fa-database fa-1_5x text-xl"></i></div>
                                    <div class="flex flex-col">
                                        <div class="text-blue-500">pgadmin</div>
                                        <description class="text-gray-400 text-sm">
                                            Datenbankverwaltung für die Testumgebung
                                        </description>
                                    </div>
                                </div>
                            </a>
                        </content>
                    </card>
                </div>


                <div class="_border-2 _border-dashed rounded-lg _border-gray-300 dark:_border-gray-600 h-32 md:h-64">

                    <!-- SAFweb2 Data -->
                    <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                        <header class="flex px-4 items-center">
                            <div class="font-semibold">
                                <i class="fa fa-info fa-2x text-gray-400"></i>
                            </div>
                            <div class="w-full pt-2">
                                <span class="font-semibold text-2xl">
                                    <p class="ml-3 pt-3"><?php out('appname') ?></p>
                                </span>
                                <p class="ml-3">Release <?php echo out('release') ?></p>
                            </div>
                        </header>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-database fa-1_5x text-xl"></i> System-Datenbank:</div>
                                <div class=""><?php out('systemdb') ?></div>
                            </div>
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-database fa-1_5x text-xl"></i> Datenbank-Admin:</div>
                                <div class=""><?php out('pgadmin') ?></div>
                            </div>
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-server fa-1_5x text-xl"></i> Server OS:</div>
                                <div class=""><?php out('server-os') ?></div>
                            </div>
                            <div class="flex justify-between">
                                <div><i class="fa fa-code fa-1_5x text-xl"></i> PHP:</div>
                                <div class=""><?php out('php-version') ?></div>
                            </div>
                        </content>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-cube fa-1_5x text-xl"></i> oraAPI:</div>
                                <div class=""><?php out('oraapi') ?></div>
                            </div>
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-cube fa-1_5x text-xl"></i> odbcAPI:</div>
                                <div class=""><?php out('odbcapi') ?></div>
                            </div>
                        </content>

                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-vector-square fa-1_5x text-xl"></i> SAFweb.core:</div>
                                <div class=""><?php out('core') ?></div>
                            </div>
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-vector-square fa-1_5x text-xl"></i> MIS.sivas:</div>
                                <div class=""><?php out('mis.sivas') ?></div>
                            </div>
                            <div class="flex justify-between">
                                <div class=""><i class="fa fa-vector-square fa-1_5x text-xl"></i> NEO.sivas:</div>
                                <div class=""><?php out('neo.sivas') ?></div>
                            </div>
                        </content>
                    </card>
                </div>

            </div>

            <div class="grid grid-cols-3 gap-4 mb-4">

                <div class="_border-2 _border-dashed rounded-lg _border-gray-300 dark:_border-gray-600 h-32 md:h-64">

                    <!-- SAFweb2 Data -->
                    <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                        <header class="flex px-4 items-center">
                            <div class="font-semibold">
                                <i class="fa fa-user fa-2x text-gray-400"></i>
                            </div>
                            <div class="w-full pt-2">
                                <span class="font-semibold text-2xl">
                                    <p class="ml-3 pt-3"><?php out('customer', 'customData') ?></p>
                                </span>
                                <p class="ml-3"><?php echo out('mandantory', 'customData') ?></p>
                                <p class="ml-3">LcID: <?php echo out('licid', 'customData') ?></p>
                            </div>
                        </header>

                        <?php foreach ($customData['urls'] as $url): ?>
                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <a class="" href="<?php echo $url['url'] ?>" target="_blank">
                                <div class="flex gap-3">
                                    <div><i class="fa fa-link fa-1_5x text-xl"></i></div>
                                    <div class="flex flex-col">
                                        <div class="text-blue-500"><?php echo $url['name'] ?> </div>
                                        <description class="text-gray-400 text-sm">
                                            <?php echo $url['desc'] ?>
                                        </description>
                                    </div>
                                </div>
                            </a>
                        </content>
                        <?php endforeach ?>
                    </card>
                </div>

            </div>

        </main>



    </div>

<?php
include_once './inc/footer.php';