<?php
    include_once './inc/core.php';
    
    $customData = include __DIR__.'/data.php';
    $appData = [
        'vendor' => 'Safineia GmbH',
        'environment' => 'Testserver 10.100.0.134',
        'appname' => 'SAFweb2',
        'release' => '2.1.17',
        'systemdb' => 'PostgreSQL 18.0',
        'pgadmin' => '4.8',
        'server-os' => 'Debian 12',
        'php-version' => '8.4',
        'oraapi' => '0.1.12',
        'odbcapi' => '-.-.-',
        'core' => '0.1.1',
        'mis.sivas' => '0.1.1',
        'neo.sivas' => '0.1.1'
    ];
    
    $card1 = array(
        'icon' => 'industrie',
        'color' => 'text-ctrl-green',
        'title' => getData('appname'),
        'link' => getData('APP_PROD_URL','customData'),
        'description' => '<b>Produktivumgebung '.getData('release').'</b>',
        'active' => $customData['APP_PROD_ACTIVE'],
        'content' => [
            [
                [
                    'typ' => 'link',
                    'link' => getData('APP_PROD_URL', 'customData'),
                    'linktext' => getData('appname'). ' App',
                    'icon' => 'columns',
                    'description' => 'Die App für den täglichen Gebrauch',
                ],
                [
                    'typ' => 'link',
                    'link' => getData('PGADMIN_PROD_URL', 'customData'),
                    'linktext' => 'pgadmin',
                    'icon' => 'database',
                    'description' => 'Datenbankverwaltung',
                ],
            ]
        ]
    );
    $card2 = array(
        'icon' => 'wrench',
        'color' => 'text-ctrl-orange',
        'title' => getData('appname'),
        'link' => getData('APP_TEST_URL','customData'),
        'description' => 'Testumgebung '.getData('release'),
        'active' => $customData['APP_TEST_ACTIVE'],
        'content' => [
            [
                [
                    'typ' => 'link',
                    'link' => getData('APP_TEST_URL', 'customData'),
                    'linktext' => getData('appname'). ' Test App',
                    'icon' => 'table',
                    'description' => 'Die App mit neuen Funktionen zum testen',
                ],
                [
                    'typ' => 'link',
                    'link' => getData('PGADMIN_TEST_URL', 'customData'),
                    'linktext' => 'pgadmin',
                    'icon' => 'database',
                    'description' => 'Datenbankverwaltung für die Testumgebung',
                ]
            ]
        ]
    );
    $cardSafwebData = array(
        'icon' => 'info',
        'color' => '',
        'title' => getData('appname'). ' Info',
        'link' => null,
        'description' => 'Release '.getData('release'),
        'active' => null,
        'content' => [
            [
                [
                    'typ' => 'info', 'icon' => 'database', 'key' => 'System-Database', 'value' => getData('systemdb'),
                ],
                [
                    'icon' => 'database', 'key' => 'DB-Admin', 'value' => getData('pgadmin'),
                ],
                [
                    'icon' => 'server', 'key' => 'Server OS', 'value' => getData('server-os'),
                ],
                [
                    'icon' => 'code', 'key' => 'PHP', 'value' => getData('php-version'),
                ]
            ],
            [
                [
                    'typ' => 'info', 'icon' => 'cube', 'key' => 'oraAPI', 'value' => getData('oraapi'),
                ],
                [
                    'icon' => 'cube', 'key' => 'odbcAPI', 'value' => getData('odbcapi'),
                ],
            ],
            [
                [
                    'typ' => 'info', 'icon' => 'vector-square', 'key' => 'SAFweb.core', 'value' => getData('core'),
                ],
                [
                    'icon' => 'vector-square', 'key' => 'MIS.sivas', 'value' => getData('mis.sivas'),
                ],
                [
                    'icon' => 'vector-square', 'key' => 'NEO.sivas', 'value' => getData('neo.sivas'),
                ],
            ]
        ]
    );
    $cardSafwebLicense = array(
        'icon' => 'user',
        'color' => '',
        'title' => getData('customer', 'customData'),
        'link' => null,
        'description' => getData('mandantory', 'customData'),
        'active' => null,
        'content' => [
            [
                [
                    'typ' => 'info', 'icon' => 'key', 'key' => 'Lizenz-ID', 'value' => getData('licid', 'customData')
                ]
            ],
            [
                [
                    'typ' => 'link',
                    'link' => getData('CUSTOM_DOCS_URL', 'customData').'/safweb2/releasenotes/'.getData('release'),
                    'linktext' => 'Releasenotes '.getData('release'),
                    'icon' => 'link',
                    'description' => 'Kurze Beschreibung der Neuerungen im Programm.',
                ]
            ]
        ]
    );

    include_once './inc/head.php';
?>
    <div class="antialiased bg-gray-50 dark:bg-gray-900">
<?php
        include_once './inc/nav.php';
?>

        <main id="mainContainer" class="p-6 _md:ml-64 h-auto pt-25">

            <div id="card-group" class="flex flex-1 flex-wrap gap-4 py-5">

                <!-- SAFweb2 PRODUCTION -->
                <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                    <?php echo card_header($card1) ?>
                    <?php echo card_content($card1) ?>
                </card>

                <!-- SAFweb2 TEST -->
                <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                    <?php echo card_header($card2) ?>
                    <?php echo card_content($card2) ?>
                </card>

                <!-- SAFweb2 Data -->
                <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                    <?php echo card_header($cardSafwebData) ?>
                    <?php echo card_content($cardSafwebData) ?>
                </card>
                
                <!-- SAFweb2 Data -->
                <card class="flex flex-col bg-white max-w-96 border border-gray-300">
                    <?php echo card_header($cardSafwebLicense) ?>
                    <?php echo card_content($cardSafwebLicense) ?>

                    <!-- URLS from data.php -->
                    <?php foreach ($customData['urls'] as $url): ?>
                        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
                            <a class="" href="<?php echo $url['url'] ?>" target="_blank">
                                <div class="flex gap-3">
                                    <div><i class="fa fa-link fa-1_5x text-xl"></i></div>
                                    <div class="flex flex-col">
                                        <div class="text-blue-500"><?php echo $url['name'] ?> </div>
                                        <description class="text-gray-400 text-sm">
                                            <?php echo $url['desc'] ?>
                                        </description>
                                    </div>
                                </div>
                            </a>
                        </content>
                    <?php endforeach ?>

                </card>

            </div>

        </main>


    </div>

<?php
include_once './inc/footer.php';