<?php
function out($key, $section = 'appData') {
    global $appData, $customData;

    echo ${$section}[$key];
}

function getData($key, $section = 'appData') {
    global $appData, $customData;

    return ${$section}[$key];
}

function getRelease() {
    $releaseData = file_get_contents(__DIR__.'/releases.json');
    $releases = json_decode($releaseData, true);
    $currentRelese = $releases['releases'][0]['version'];
    return $currentRelese;
}



function card_header($data) {
    $icon = $data['icon'] ?? 'info';
    $iconColor = $data['color'] ?? 'text-black';
    $title = $data['title'] ?? 'TITLE';
    $link = $data['link'] ?? null;
    $description = $data['description'] ?? 'DESCRIPTION';
    $status = $data['active'] ?? null;
    
    $statusString = '';
    if ($status != null) {
        if ($status === true) {
            $statusString = '<p class="ml-3 font-bold text-green-400">aktiv</p>';
        } elseif ($status === false) {
            $statusString = '<p class="ml-3 font-bold text-red-400">nicht aktiv</p>';
        }
    }

    $linkString = '';
    if ($link !== null) {
        $linkString = '<a href="'.$link.'">'.$title.'</a>';
    } else {
        $linkString = $title;
    }
    
    return '
        <header class="flex p-3 items-center">
            <div class="font-semibold">
                <i class="fa fa-'.$icon.' fa-2x text-gray-400"></i>
            </div>
            <div class="w-full">
                <span class="font-semibold ml-3 text-2xl '.$iconColor.'">
                    '.$linkString.'
                </span>
                <p class="ml-3">'.$description.'</p>
                '.$statusString.'
            </div>
        </header>';
}

function card_content($data) {
    $content = '';
    foreach ($data['content'] as $contentItem) {
        $type = $contentItem[0]['typ'];
        if ($type == 'info') {
            $content .= card_info_content($contentItem);
        } elseif ($type == 'link') {
            foreach ($contentItem as $linkItem) {
                $content .= card_link_content($linkItem);
            }
        }
    }
    return $content;
}


function card_link_content($data) {
    $link = $data['link'] ?? '#';
    $linktext = $data['linktext'] ?? '';
    $icon = $data['icon'] ?? 'info';
    $description = $data['description'] ?? '';
    
    return '
        <content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
            <a class="" href="'.$link.'" target="_blank">
                <div class="flex gap-3">
                    <div><i class="fa fa-'.$icon.' fa-1_5x text-xl"></i></div>
                    <div class="flex flex-col">
                        <div class="text-blue-500">'.$linktext.'</div>
                        <description class="text-gray-400 text-sm">
                            '.$description.'
                        </description>
                    </div>
                </div>
            </a>
        </content>    
    ';
}

function card_info_content($data) {
    
    $content = '<content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">';
    
    foreach ($data as $item) {
        $icon = $item['icon'];
        $key = $item['key'];
        $value = $item['value'];
        $content .= '
            <div class="flex justify-between">
                <div class="_px-2"><i class="mx-2 fa fa-'.$icon.' fa-1_5x text-xl"></i> '.$key.':</div>
                <div class="px-2">'.$value.'</div>
            </div>
        ';
    }
    $content .= '</content>';
    return $content;
}