#! /bin/bash

if [ ! "$BASH_VERSION" ] ; then
    exec /bin/bash "$0" "$@"
fi

RELEASE=0.2.3
GITHOST=95.217.217.117
GITUSER=safweb
GITSAFADMIN=safadmin
GITREPO=/opt/gitrepositories

GREEN='\e[32m'
YELLOW='\e[33m'
RED='\e[31m'
COLOROFF='\e[0m'

# ifconfig will be patched to net-tools while installing
SOFTWARE=('sudo' 'btop' 'htop' 'screen' 'git' 'tree' '/sbin//sbin/ifconfig')
SAFWEBBASE=`pwd`
TESTPATH=$SAFWEBBASE/test
PRODPATH=$SAFWEBBASE/produktiv
# necessary Directoties whithin SAFWEBBASE
DIRS=('' 'installation' 'startpage' 'test' 'test/app' 'test/docker' 'test/oraapi' 'test/odbcapi' 'produktiv' 'produktiv/app' 'produktiv/docker' 'produktiv/oraapi' 'produktiv/odbcapi')
# Ownerships
DIRS_OS=('safadmin' 'safadmin' 'safadmin' 'safadmin' 'safweb' 'safadmin' 'safweb' 'safweb' 'safadmin' 'safweb' 'safadmin' 'safweb' 'safweb')



show_usage()
{
  echo "SAFweb2 setup. (C) Safineia GmbH, 2025. v$RELEASE"
  echo "Usage:  ./setup.sh <option>"
  echo "Options:"
  echo "  -c   check all settings"
  echo "  -p   prepare (create directories and install systemtools)"
  echo "  -sp  install Startpage for Webserver"
  echo "  -it  install safweb2 in test environment"
#  echo "  -ip  install safweb2 in produktiv environment"
  echo "  -ut  update safweb2 in test environment"
#  echo "  -up  update safweb2 in produktiv environment"
  echo "  -cu  code update menu"
}

show_codeupdate_menu()
{
    echo "1)   update Test App"
    echo "2)   update Test ORA-API"
    echo "3)   update Test ODBC-API"
    echo "Q)   Quit"

    read k
    case $k in
        1) echo "update Test App"
          update_test_app
          ;;
        2) echo "update Test Ora-Api"
          update_test_oraapi
          ;;
        3) echo "update Test ODBC-Api"
          update_test_odbcapi
          ;;
        *) echo "falsche Auswahl"
          show_codeupdate_menu
          ;;
    esac
}


confirmation()
{
  echo "continue [J/n]?"
  read k
  if [ "$k" != "J" ] && [ "$k" != "" ]; then
    echo "your choice... Bye!"
    exit 1
  fi
}


install_software()
{
  # Update
  echo -e '[X] '$YELLOW'Updating System...'$COLOROFF
  apt-get update -y
  echo -e '[X] '$GREEN'System Update OK'$COLOROFF


  # neseccary software
  for app in ${SOFTWARE[@]}; do
    cmd='command -v '$app
    HAS_APP=$($cmd)
    if [ $HAS_APP ]; then
      echo -e '[X] '$GREEN$app' is available. OK'$COLOROFF
      HAS_APP=''
    else
      if [ "$app" = "/sbin/ifconfig" ]; then
        app='net-tools'
      fi
      echo -e $YELLOW$app' needed. Installing...'$COLOROFF
      apt-get -y install $app
      echo -e $GREEN' OK'$COLOROFF
    fi
  done

  echo -e '[X] '$GREEN$app' Copy Updater. OK'$COLOROFF
  /bin/cp -rf $SAFWEBBASE/installation/update_installer.sh $SAFWEBBASE


  # special case docker
  HAS_DOCKER="$(command -v docker --version)"
  if [ $HAS_DOCKER ]; then
    echo -e '[X] '$GREEN'docker '$HAS_DOCKER' is available. OK'$COLOROFF
  else
    echo "Docker needed. Installing:"
    apt-get update -y
    apt-get install -y ca-certificates curl
    install -m 0755 -d /etc/apt/keyrings
    curl -fsSL https://download.docker.com/linux/debian/gpg -o /etc/apt/keyrings/docker.asc
    chmod a+r /etc/apt/keyrings/docker.asc

    echo \
    "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/debian \
    $(. /etc/os-release && echo "$VERSION_CODENAME") stable" | \
    sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

    apt-get update -y

    curl -fsSL https://download.docker.com/linux/debian/gpg | gpg --dearmor -o /usr/share/keyrings/docker.gpg
    echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/docker.gpg] https://download.docker.com/linux/debian bookworm stable" |tee /etc/apt/sources.list.d/docker.list > /dev/null 

    apt -y update

    apt-get install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin
  fi

  # User and Groups
  if [ $(getent group safweb) ]; then
    echo -e '[X] '$GREEN'Group safweb exists. OK'$COLOROFF
  else
    echo "Group safweb does not exist, creating"
    /sbin/groupadd safweb
  fi

  if [ $(getent passwd safweb) ]; then
    echo -e '[X] '$GREEN'User safweb exists. OK'$COLOROFF
  else
    echo "User safweb does not exist, creating"
    /sbin/useradd -g safweb -m -p wnmy42043 -s /bin/bash safweb
  fi

  cmd=$(getent group safadmin)
  if [ "$cmd" != "" ]; then
    echo -e '[X] '$GREEN'Group safadmin exists. OK'$COLOROFF
  else
    echo "Group safadmin does not exist, creating"
    /sbin/groupadd -g safadmin -m -p wnmy42043 -s /bin/bash safadmin
  fi

  cmd=$(getent passwd safadmin)
  if [ "$cmd" != "" ]; then
    echo -e '[X] '$GREEN'User safadmin exists. OK'$COLOROFF
  else
    echo "User safadmin does not exist, creating"
    /sbin/useradd -g safadmin safadmin
  fi
  cmd=$(/usr/bin/id -nG "safadmin" | /usr/bin/grep -o "docker")
  if [ "$cmd" = "docker" ]; then
    echo -e '[X] '$GREEN'User safadmin is in Group docker. OK'$COLOROFF
  else
    /sbin/usermod -a -G docker safadmin
    echo -e '[X] '$GREEN'Add User safadmin to Group docker. OK'$COLOROFF
  fi 


}


check_ensure_directories()
{
    mode=$1 # 'check' or 'fix'

    # neseccary directories
    for i in ${!DIRS[@]}; do
      dir=$SAFWEBBASE/${DIRS[i]}
      owner=${DIRS_OS[i]}

      if [ -d $dir ]; then
          echo -e '[X] '$GREEN$dir' exists. OK'$COLOROFF
          cmd=$(stat -c '%U' $dir)
          if [ "$cmd" != "$owner" ]; then
              echo -e $YELLOW'Need fix ownership of '$dir'...'$COLOROFF
              if [ "$mode" = 'fix' ]; then
                  /usr/bin/chown $owner:$owner -R $dir
                  echo -e '[ ] '$GREEN'fixed ownership ($owner) of $dir'$COLOROFF
              fi
          fi
      else
        echo -e $YELLOW'Need creation of '$dir'...'$COLOROFF
        if [ "$mode" = "fix" ]; then
            /usr/bin/mkdir -p $dir
            /usr/bin/chown $owner:$owner -R $dir
            echo -e '[X] '$YELLOW$dir' Directory created'$COLOROFF
        fi
      fi
    done

}



# git clone the safweb Testenvironment
install_test()
{
  if [ ! -d "$SAFWEBBASE/test" ]; then
    echo "directory $SAFWEBBASE/test missing"
    echo "create directory structure [J/n]?"
    read k
    if [ "$k" = "J" or "$k" = "" ]; then
      check_ensure_directories fix
    else
      echo "break"
      exit 1
    fi
  fi

  # git clone test and testdocker
  /usr/bin/sudo -u $GITSAFADMIN /usr/bin/git clone $GITSAFADMIN@$GITHOST:$GITREPO/safweb2-docker.git -b develop $SAFWEBBASE/test/docker
  /usr/bin/sudo -u $GITUSER /usr/bin/git clone $GITUSER@$GITHOST:$GITREPO/safweb2.git -b develop $SAFWEBBASE/test/app
  /usr/bin/sudo -u $GITUSER /usr/bin/git clone $GITUSER@$GITHOST:$GITREPO/safweb2-oraapi.git -b develop $SAFWEBBASE/test/oraapi
}

update_test_docker()
{
    cd /opt/safweb/test/docker
    /usr/bin/sudo -u $GITSAFADMIN /usr/bin/git pull origin develop $GITSAFADMIN@$GITHOST:$GITREPO/safweb2-docker.git main
}

update_test_app()
{
    cd /opt/safweb/test/app
    /usr/bin/sudo -u $GITUSER /usr/bin/git pull origin develop $GITUSER@$GITHOST:$GITREPO/safweb2.git main
}

update_test_oraapi()
{
    cd /opt/safweb/test/oraapi
    /usr/bin/sudo -u $GITUSER /usr/bin/git pull origin develop $GITUSER@$GITHOST:$GITREPO/safweb2-oraapi.git main
}

update_test()
{
    if [ ! -d "/opt/safweb/test" ]; then
      echo -e $RED'directory '$TESTPATH' missing'$COLOROFF
      echo "break"
      exit 1
    fi

    #cd /opt/safweb/test/docker
    #/usr/bin/sudo -u $GITSAFADMIN /usr/bin/git pull $GITSAFADMIN@$GITHOST:$GITREPO/safweb2-docker.git main
    update_test_docker

    #cd /opt/safweb/test/app
    #/usr/bin/sudo -u $GITUSER /usr/bin/git pull $GITUSER@$GITHOST:$GITREPO/safweb2.git main
    update_test_app

    #cd /opt/safweb/test/oraapi
    #/usr/bin/sudo -u $GITUSER /usr/bin/git pull $GITUSER@$GITHOST:$GITREPO/safweb2-oraapi.git main
    update_test_oraapi
}


exec_checks()
{
  if [ $(getent group safweb) ]; then
    echo -e '[X] '$GREEN'Group safweb exists. OK'$COLOROFF
  else
    echo -e '[ ] '$YELLOW'Group safweb does not exist.'$COLOROFF
  fi

  if [ $(getent group safadmin) ]; then
    echo -e '[X] '$GREEN'Group safadmin exists. OK'$COLOROFF
  else
    echo -e '[ ] '$YELLOW'Group safadmin does not exist'$COLOROFF
  fi

  if [ $(getent passwd safweb) ]; then
    echo -e '[X] '$GREEN'User safweb exists. OK'$COLOROFF
  else
    echo -e '[ ] '$YELLOW'User safweb does not exist'$COLOROFF
  fi

  cmd=$(getent passwd safadmin | /usr/bin/grep -o safadmin:x)
  if [ "$cmd" != "" ]; then
    echo -e '[X] '$GREEN'User safadmin exists. OK'$COLOROFF
    cmd=$(/usr/bin/id -nG "safadmin" | /usr/bin/grep -o "docker")
    if [ "$cmd" = "docker" ]; then
      echo -e '[X] '$GREEN'User safadmin is in Group docker. OK'$COLOROFF
    else
      echo -e '[ ] '$YELLOW'User safadmin need to be in Group docker.'$COLOROFF
    fi 
  else
    echo -e '[ ] '$YELLOW'User safadmin does not exist'$COLOROFF
  fi

  # neseccary software
  for app in ${SOFTWARE[@]}; do
    cmd='command -v '$app
    HAS_APP=$($cmd)
    if [ $HAS_APP ]; then
      echo -e '[X] '$GREEN$app' is available. OK'$COLOROFF
      HAS_APP=''
    else
      echo -e '[ ] '$YELLOW$app' needed.'$COLOROFF
    fi
  done

  HAS_DOCKER="$(command -v docker --version)"
  if [ $HAS_DOCKER ]; then
    echo -e '[X] '$GREEN'docker '$HAS_DOCKER' is available. OK'$COLOROFF
  else
    echo -e '[ ] '$YELLOW$'docker needed.'$COLOROFF
  fi

  # directories
  check_ensure_directories
}


exec_prepare()
{
  echo -e "Execute Command prepare, create directories and install System-Tools."
  confirmation
  install_software
  check_ensure_directories fix
}


exec_install_test()
{
  echo -e "Command Install Test"
  confirmation
  install_test
}


exec_update_test()
{
  echo -e $YELLOW'Command Update Test'$COLOROFF
  confirmation
  update_test
}


exec_install_startpage()
{
  DIR="$SAFWEBBASE/startpage"
  if [ ! -d $DIR ]; then
    echo -e '[ ] '$YELLOW''$DIR' Directory not found'$COLOROFF
    exit 1
  fi    
    
  cmd=$(stat -c '%U' $DIR)
  if [ "$cmd" != "safadmin" ]; then
    echo -e '[ ] '$YELLOW'ownership is wrong ('$cmd')'$COLOROFF
    exit 1
  fi
  
  /bin/cp -a $SAFWEBBASE/installation/startpage/* $DIR/
  cd $DIR
  /bin/cp -a custom_index.html index.html
  echo -e '[X] '$GREEN'Startpage installed. OK'$COLOROFF
}



#
# MAIN Entry
#

# Check permissions
if [ "$(id -u)" -ne "0" ]; then
  echo -e $YELLOW'You need to be root'$COLOROFF
  exit 1
fi

# Check System
system=$(uname)
if [ "$system" != "Linux" ]; then
  echo -e $RED'This System seems to be a non Linux System ($system)'$COLOROFF
  exit 0
fi

# $# = amount parameter, no parameter = 0
# $1 .. $9 first 9 Parameter
if [ "$#" -eq "0" ]; then
  show_usage
  exit 0
fi


if [ "$#" -gt 1 ]; then
  echo -e $YELLOW'only 1 Parameter allowed'$COLOROFF
  exit 1
fi

case $1 in
  '-c')
      exec_checks
      exit 0
      ;;
  '-p')
      exec_prepare
      exit 0
      ;;
  '-it')
      exec_install_test
      exit 0
      ;;
  '-ut')
      exec_update_test
      exit 0
      ;;
  '-sp')
      exec_install_startpage
      exit 0
      ;;
  '-cu')
      show_codeupdate_menu
      exit 0
  # -ip
  # -up
esac

