import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                'white': '#fefefe',
                'swblue-500': 'oklch(49.04% 0.1269 247.68)',
                'swblue-600': 'oklch(36.06% 0.0915 246.49)',
                'swblue-700': 'oklch(41.94% 0.1061 247.11)',
                'swwhite': 'oklch(94.91% 0 0)',
                'swblack': 'oklch(38.67% 0 0)',
                'swgreen-500': 'oklch(73.95% 0.2268 142.85)',
                'swlink-500': 'oklch(61.24% 0.1153 252.28)',
                'ctrl-green': '#33cc33',
                'ctrl-blue': '#0a64a4',
                'ctrl-tbl-blue': '#65a5d1',
                'ctrl-tbl-orange': '#daa541',
                'ctrl-light': '#eeeeee',
                'ctrl-orange': '#daa541',
                'ctrl-red': '#e33f3f',

            },
            screens: {
                print: { raw: 'print' },
                screen: { raw: 'screen' },
            },
        },
    },

    plugins: [forms],
};
