<!-- CARD -->
<?php
    $meta = $data['meta'];
    $fn = $data['functions'] ?? [];

    $icon = $meta['icon'] ?? 'fa-global';
    $moduleurl = $meta['link'] ?? '/';
    $title = $meta['name'] ?? 'TITLE';
    $desc = $meta['desc'] ?? 'DESC';
    $disabled = false;
    if(isset($meta['disabled']) && $meta['disabled'] == 'true') {
        $disabled = true;
    }


?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visitlink', $moduleurl)): ?>
    <card class="flex flex-col bg-white dark:bg-gray-600 max-w-96 border border-gray-300">
        <header class="flex p-3 items-center">
            <div class="font-semibold">
                <i class="fa <?php echo e($icon); ?> fa-2x dark:text-gray-100"></i>
            </div>
            <div class="w-full">
                <?php if($disabled): ?>
                    <span class="font-semibold ml-3 text-gray-400 text-2xl">
                        <?php echo e($title); ?>

                    </span>
                <?php else: ?>
                    <span class="font-semibold ml-3 text-ctrl-green text-2xl">
                        <a href="<?php echo e($moduleurl); ?>"><?php echo e($title); ?></a>
                    </span>
                <?php endif; ?>
                <p class="ml-3 dark:text-gray-200"><?php echo e($desc); ?></p>
            </div>
        </header>

        <?php $__currentLoopData = $fn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m => $mdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visitlink', $mdata['meta']['link'])): ?>
                <?php if (isset($component)) { $__componentOriginalce98d3a16570c1374d3454ae4ccce3bb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalce98d3a16570c1374d3454ae4ccce3bb = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'core::components.navigation.cardentry','data' => ['data' => $mdata]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::navigation.cardentry'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($mdata)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalce98d3a16570c1374d3454ae4ccce3bb)): ?>
<?php $attributes = $__attributesOriginalce98d3a16570c1374d3454ae4ccce3bb; ?>
<?php unset($__attributesOriginalce98d3a16570c1374d3454ae4ccce3bb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalce98d3a16570c1374d3454ae4ccce3bb)): ?>
<?php $component = $__componentOriginalce98d3a16570c1374d3454ae4ccce3bb; ?>
<?php unset($__componentOriginalce98d3a16570c1374d3454ae4ccce3bb); ?>
<?php endif; ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </card>
<?php endif; ?>
<!-- CARD END -->
<?php /**PATH /var/www/app/app/modules/Core/resources/views/components/navigation/card.blade.php ENDPATH**/ ?>