<?php if(isset($name)): ?>
<div class="p-1 border-b-[1px] bg-ctrl-tbl-blue">
    <label for="<?php echo e($name); ?>">
        <?php echo $label ?? ucfirst($name); ?>

    </label>
</div>
<?php endif; ?>

<?php
    if (!isset($format)) { $format = null; }
    $precision = 2;
    $_format = $format;
    $textalign = ' text-left ';

    if ($format !== null) {
        $split = preg_split('/\,/', $format);
        if (is_array($split) && sizeof($split) > 1) {
            $_format = $split[0];
            $precision = $split[1];
        }
    }

    switch ($_format) {
        case 'currency':
            $out = number_format(round((float) $value, $precision),$precision, ',', '.'). "€";
//            $textalign = ' text-right ';
            break;
        case 'number':
            $out = number_format((float) $value, $precision, ',', '.');
//            $textalign = ' text-right ';
            break;
        case 'date':
            $out = date_format(date_create($value),'d.m.Y');
            break;
        case 'percent':
            $out = $value . '%';
//            $textalign = ' text-right ';
            break;
        case 'checkbox':
        case 'boolean':
            $out = $value ? '✅' : '❌';
            break;
        default:
            $out = $value;
            break;
    }
?>
<div class="p-1 _border-b-[1px] border-blue-300">
    <p class="text-sm <?php echo e($textalign); ?> font-mono bg-gray-200 p-0">
        <?php echo e($out); ?>

    </p>
</div>
<?php /**PATH /var/www/app/resources/views/components/safweb/forms/info.blade.php ENDPATH**/ ?>