<?php
    $tableRecords = 0;
    $hasFooter = isset($tableDef['footer']);
    $footerResult = [];
    $footerOperations = [];
    $footerColCount = 0;

    $groupColumn = null;
    $groupValue = null;
    $groupCount = null;
    $groupSum = [];
    $has_group = null;
    $has_group_sum = false;
    $groupReplaceColumn = null;
    $groupReplaceColumnCount = 0;

    $colCount = count($tableDef['header']);
    $sumColSpan = 0;
    if ($hasFooter) {
        $footerColCount = count($tableDef['footer']);
        $sumColSpan = $colCount - $footerColCount;
    }

    if(is_null($data)) {
        $data = [];
    }

    if ($hasFooter) {
        foreach ($tableDef['header'] as $key => $label) {
            $footerResult[$key]['calc'] = 0;
            $footerResult[$key]['format'] = false;
            $footerOperations[$key] = isset($tableDef['footer'][$key]) ? $tableDef['footer'][$key]['fn'] : false;
        }
    }
?>

<table class="table table-sm border-collapse">
    <?php if (isset($component)) { $__componentOriginal0767c569b80c86998d591f6317ec82d4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0767c569b80c86998d591f6317ec82d4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.safweb.table.table-head','data' => ['tableDef' => $tableDef]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('safweb.table.table-head'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['tableDef' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableDef)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0767c569b80c86998d591f6317ec82d4)): ?>
<?php $attributes = $__attributesOriginal0767c569b80c86998d591f6317ec82d4; ?>
<?php unset($__attributesOriginal0767c569b80c86998d591f6317ec82d4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0767c569b80c86998d591f6317ec82d4)): ?>
<?php $component = $__componentOriginal0767c569b80c86998d591f6317ec82d4; ?>
<?php unset($__componentOriginal0767c569b80c86998d591f6317ec82d4); ?>
<?php endif; ?>

    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $tableRecords++;
            $rowColor = 'dark:bg-gray-200';
            $inGroupReplace = false;

            if ($loop->even) {
                $rowColor = 'bg-gray-200 dark:bg-gray-100';
            }

            $rowType = 'model';
            if (is_a($row, 'stdClass')) {
                $rowType = 'stdClass';
            } else if (is_array($row)) {
                $rowType = 'array';
            }

            if (isset($tableDef['meta']) && isset($tableDef['meta']['keyname'])) {
                $idName = $tableDef['meta']['keyname'];
            } else {
                if ($rowType == 'array') {
                    $id = $row[$idName];
                } else {
                    $idName = $row->getKeyName();
                    $id = $row->{$idName};
                }
            }

            // to mark the last changed row
            $lastChanged = app('request')->lastChanged;
            if (isset($lastChanged) && $lastChanged == $id) {
                $rowColor = ' bg-green-200 ';
            }

            // Test if Groupcolumn is defined. Run only once!
            if (is_null($has_group)) {
                $columnDatas = $tableDef['columns'];
                foreach($columnDatas as $col => $columnData) {
                    if (isset($columnData['group'])) {
                        $has_group = true;
                        $groupCount = 1;
                        $groupColumns = explode(',', $columnData['group']);
                        $groupColumn = $groupColumns[0];
                        $groupValue = $row[$groupColumn];
                        if (isset($columnData['groupsum'])) {
                            $has_group_sum = true;
                            foreach ($columnData['groupsum'] as $grpsum) {
                                $groupSum[$grpsum] = 0;
                            }
                        }
                    }
                    if (isset($columnData['group_replace'])) {
                        $groupReplaceColumn = $columnData['group_replace'];
                        $groupReplaceColumnCount = count($groupColumns);
                    }
                }
            }
            // Group Change
            if ($has_group == true) {
                if($row[$groupColumn] !== $groupValue) {
                    $groupValue = $row[$groupColumn];
                    $groupCount = 1;
                }
            }

        ?>
        <tr class="border border-gray-300 <?php echo e($rowColor); ?>">
            <?php if($has_group == true && $groupCount == 1): ?>
                <?php if($tableRecords > 1): ?>
                    <tr class="border border-gray-300 <?php echo e($rowColor); ?>">
                        <td colspan="<?php echo e($sumColSpan); ?>" class="text-right text-sm"></td>
                        <?php $__currentLoopData = $groupSum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $grpsum): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $gs = number_format(round((float) $grpsum, 2), 2, ',', '.'). "€";
                            ?>
                            <td class="<?php echo \Illuminate\Support\Arr::toCssClasses(['border','border-gray-300','text-xs','text-right','font-semibold',$cellColor,'px-2','text-nowrap']); ?>"> <?php echo e($gs); ?></td>
                            <?php $groupSum[$key] = 0; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                <?php endif; ?>
                    <td colspan="<?php echo e($colCount); ?>" class="bg-ctrl-tbl-blue px-2 text-left text-sm font-semibold border border-gray-300 text-nowrap">
                        <?php $__currentLoopData = $groupColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grp_col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($row[$grp_col]); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <tr class="border border-gray-300 <?php echo e($rowColor); ?>">
            <?php endif; ?>

            <?php $groupCount++; ?>

            <?php $__currentLoopData = $tableDef['columns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $columnData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $textRight = '';
                    $cellValue = '--';
                    $subid = null;

                    // split sub (model.attribute, so multiple sub field are possible
                    $split = preg_split('/\./', $key);
                    if (is_array($split) && sizeof($split) > 1) {
                        $key = $split[0];
                    }

                    if (is_a($row, 'stdClass')) {
                        $cellValue = $row->{$key};
                        $calcCellValue = $row->{$key};
                    } else if (is_array($row)) {
                        $cellValue = $row[$key];
                        $calcCellValue = $row[$key];
                    }
                    else {
                        if (isset($row->attributesToArray()[$key])) {
                            $cellValue = $row->{$key};
                        }
                    }

                    // Column must have the Relationname
                    if(isset($columnData['sub'])) {
                        if($row->$key !== null) {
                            $cellValue = $row->$key->{$columnData['sub']};
                            $subid = $row->$key->id;
                        }
                    }

                    if ($hasFooter) {
                        switch ($footerOperations[$key]) {
                            case 'sum':
                                $footerResult[$key]['calc'] += (float) $calcCellValue;
                                break;
                            default:
                                break;
                        }
                    }

                    // Sum within the Group
                    if (array_key_exists($key, $groupSum)) {
                        $groupSum[$key] += (float) $calcCellValue;
                    }


                    if(isset($columnData['type'])) {
                        $precision = 2;
                        $_format = $columnData['type'];

                        $split = preg_split('/\,/', $columnData['type']);
                        if (is_array($split) && sizeof($split) > 1) {
                            $_format = $split[0];
                            $precision = $split[1];
                        }

                        switch ($_format) {
                            case('boolean'):
                                $cellValue = $cellValue ? '✅' : '❌';
                                $textRight = ' text-center ';
                                break;
                            case('date'):
                                if (is_a($cellValue, 'DateTimeInterface') ) {
                                    $cellValue = date_format(date_create($cellValue),'d.m.Y');
                                    $textRight = ' text-right ';
                                } elseif (strlen($cellValue) == 8 && is_numeric($cellValue)) {
                                    $cellValue = date_format(date_create($cellValue), 'd.m.Y');
                                    $textRight = ' text-right ';
                                }
                                break;
                            case('year'):
                                $textRight = ' text-right ';
                                break;
                            case('float'):
                                $cellValue = number_format(round((float) $cellValue, 2),2, ',', '.');
                                $textRight = ' text-right ';
                                if ($hasFooter) {
                                    $footerResult[$key]['format'] = round((float) $footerResult[$key]['calc'], 2);
                                }
                                break;
                            case('integer'):
                                $cellValue = (int) $cellValue;
                                $textRight = ' text-right ';
                                if ($hasFooter) {
                                    $footerResult[$key]['format'] = (int) $footerResult[$key]['calc'];
                                }
                                break;
                            case('number'):
                                $cellValue = number_format(round((float) $cellValue, 2),0, ',', '.');
                                $textRight = ' text-right ';
                                if ($hasFooter) {
                                    $footerResult[$key]['format'] = round((float) $footerResult[$key]['calc'], 2);
                                }
                                break;
                            case('currency'):
                                $cellValue = number_format(round((float) $cellValue, $precision), $precision, ',', '.'). "€";
                                #$cellValue = number_format((float) $cellValue, $precision, ',', '.'). "€";
                                $textRight = ' text-right ';
                                if ($hasFooter) {
                                    #$footerResult[$key]['format'] = number_format(round((float) $footerResult[$key]['calc'], $precision), $precision, ',', '.'). "€";
                                    $footerResult[$key]['format'] = number_format((float) $footerResult[$key]['calc'], $precision, ',', '.'). "€";
                                }
                                break;
                            case('percent'):
                                $cellValue = number_format($cellValue,1 , ','). "%";
                                $textRight = ' text-right ';
                                if ($hasFooter) {
                                    $footerResult[$key]['format'] = round((float) $footerResult[$key]['calc'], 1). '%';
                                }
                                break;
                        }
                    }

                    // Link on Column to Object
                    if (isset($columnData['fnedit'])) {
                        $linkid = $id;
                        $cellValue = '<a href="'.$columnData['fnedit'].'/'.$linkid.'" class="text-blue-500">'.$cellValue.'</a>';
                    }

                    // if a relation has values, a Link on an other Columns is set
                    if (isset($columnData['fnedit_if_sub'])) {
                        $subKey = $columnData['if_sub_key'];
                        if($row->$subKey !== null) {
                            $subid = $row->$subKey->id;
                        }

                        if ($subid !== null) {
                            $linkid = $id;
                            $cellValue = '<a href="'.$columnData['fnedit_if_sub'].'/'.$linkid.'" class="text-blue-500">'.$cellValue.'</a>';
                        }
                    }

                    // a link to an Sub Relation Object is set
                    if (isset($columnData['fneditsub'])) {
                        if ($subid !== null) {
                            $cellValue = '<a href="'.$columnData['fneditsub'].'/'.$subid.'" class="text-blue-500">'.$cellValue.'</a>';
                        }
                    }

                    if (isset($columnData['btnfn'])) {
                        $cellValue = '<a href="'.$columnData['btnfn'].'/'.$id.'" class="text-ctrl-orange">'.
                            '<i class="fa fa-'.$columnData['icon'].'"></i>'.
                            '</a>';
                        $textRight = 'text-center';
                    }

                    if (isset($columnData['fnlink']) && isset($columnData['fnlinkid'])) {
                        $linkId = $row[$columnData['fnlinkid']];
                        $cellValue = '<a href="'.$columnData['fnlink'].'/'.$linkId.'" class="text-blue-500">'.
                            $cellValue.
                            '</a>';
                    }

                    $cellColor = '';
                    if (isset($columnData['orange_on'])) {
                        if ($cellValue == $columnData['orange_on']) {
                            $cellColor = ' bg-orange-200';
                        }
                    }

                ?>
                <?php if($groupReplaceColumn): ?>
                    <td colspan="<?php echo e($groupReplaceColumnCount); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['border','border-gray-300','text-sm',$textRight,$cellColor,'px-2','text-nowrap',]); ?>"><?php echo $row[$groupReplaceColumn]; ?></td>
                <?php else: ?>
                    <td class="<?php echo \Illuminate\Support\Arr::toCssClasses(['border','border-gray-300','text-sm',$textRight,$cellColor,'px-2','text-nowrap',]); ?>"><?php echo $cellValue; ?></td>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if($has_group == true): ?>
        <tr class="border border-gray-300 <?php echo e($rowColor); ?>">
            <td colspan="<?php echo e($sumColSpan); ?>" class="text-right text-sm"></td>
            <?php $__currentLoopData = $groupSum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $grpsum): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $gs = number_format(round((float) $grpsum, 2), 2, ',', '.'). "€"; ?>
                <td class="<?php echo \Illuminate\Support\Arr::toCssClasses(['border','border-gray-300','text-xs','text-right','font-semibold',$cellColor,'px-2','text-nowrap']); ?>"> <?php echo e($gs); ?></td>
                <?php $groupSum[$key] = 0; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
    <?php endif; ?>

    <?php if($hasFooter): ?>
        <tfoot>
        <tr class="bg-gray-200">
            <?php $__currentLoopData = $footerResult; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $footerCell): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td class="text-right text-sm px-2">
                    <?php if($footerOperations[$key]): ?>
                        <b><?php echo $footerCell['format']; ?></b>
                    <?php else: ?>
                        &nbsp;
                    <?php endif; ?>
                </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
        </tfoot>
    <?php endif; ?>

    <?php if($tableRecords == "0"): ?>
        <caption class="caption-bottom text-left text-xs"><b>keine Daten gefunden</b></caption>
    <?php else: ?>
        <caption class="caption-bottom text-left text-xs">Records: <?php echo e($tableRecords); ?></caption>
    <?php endif; ?>
</table>
<?php /**PATH /var/www/app/resources/views/components/safweb/table/table.blade.php ENDPATH**/ ?>