@props(['options', 'name', 'label', 'value'])

<div class="p-1 bg-ctrl-tbl-blue">
    <label for="{{ $name }}">
        {!! $label ?? ucfirst($name) !!}
    </label>
</div>
<div class="px-2">
    <select name="{{ $name }}" {{ $attributes->merge(['class' => '_w-1/4 mt-1 p-0.5 text-sm font-mono border-[1px] border-blue-900 bg-white']) }}>
        @if (isset($options))
            @foreach ($options as $_key => $_value)
                <option value="{{ $_key }}" {{ $value == $_key ? 'selected' : '' }}>{{ $_value }}</option>
            @endforeach
        @endif
    </select>
</div>
