@props(['title', 'icon', 'url'])

<content class="hover:bg-gray-200 cursor-pointer border-t border-gray-300 p-3">
    <a href="{{ $url ?? '#' }}">
        <div class="flex gap-3">
            <div>
                <i class="fa {{ $icon ?? 'fa-globe' }} fa-1_5x text-xl"></i>
            </div>
            <div class="flex flex-col">
                <div class="text-blue-500">
                    {{ $title ?? 'TITLE' }}
                </div>
                <description class="text-gray-400 text-sm">
                    {{ $slot }}
                </description>
            </div>
        </div>
    </a>
</content>
