<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" href="{{ URL::to('/') }}/images/favicon.ico" type="image/x-icon"/>

    <title>SAFweb</title>

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">

</head>
<body class="bg-gray-100 dark:bg-gray-800">
<div class="antialiased bg-gray-50 dark:bg-gray-800">
    <!-- Navigation TopNav -->
    <x-core::navigation.topnav></x-core::navigation.topnav>
    <!-- Sidebar -->
    <livewire:navigation-sidebar></livewire:navigation-sidebar>
    <!-- Main Section -->
    <main id="mainContainer" class="p-4 _md:ml-64 h-auto pt-20">
        {{ $slot }}
    </main>
</div>


<script>
    const toggleButton = document.getElementById('toggleButton');
    const sidebarContainer = document.getElementById('sidebarContainer');
    const mainContainer = document.getElementById('mainContainer');

    toggleButton.addEventListener('click', () => {
        if (sidebarContainer.style.width === '310px') {
            sidebarContainer.style.width = '0';
            mainContainer.classList.remove("md:ml-80");
        } else {
            sidebarContainer.style.width = '310px';
            mainContainer.classList.add("md:ml-80");
        }
    });
</script>

</body>
</html>
