<?php

namespace Database\Seeders;

use App\modules\Mis\Models\BikrMaschinendaten;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BikrMaschinendatenSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        if (BikrMaschinendaten::count() > 0) {
            \DB::table('bikr_maschinendaten')->truncate();
        }

        \DB::table('bikr_maschinendaten')->insert([
            [
                'name' => 'Presse',
                'bezeichnung' => 'KSP-01 (Masch. 1)',
                'beschreibung' => '',
                'anschaffungswert' => 184000,
                'restbuchwert' => 8762,
                'wiederbeschaffungswert' => 446646,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 12,
                'anschlussleistung' => 11,
                'kapazitaet_jahr' => 2112000,
                'kapazitaet_minute' => 176,
                'betriebskosten' => 14900,
                'instandhaltungskosten' => 9200,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'KSP-01 (Masch. 2)',
                'beschreibung' => '',
                'anschaffungswert' => 184000,
                'restbuchwert' => 8762,
                'wiederbeschaffungswert' => 446646,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 12,
                'anschlussleistung' => 11,
                'kapazitaet_jahr' => 2112000,
                'kapazitaet_minute' => 176,
                'betriebskosten' => 14900,
                'instandhaltungskosten' => 9200,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'KSP-11 (Masch. 1)',
                'beschreibung' => '',
                'anschaffungswert' => 212000,
                'restbuchwert' => 10095,
                'wiederbeschaffungswert' => 514610,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 21,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 19080000,
                'kapazitaet_minute' => 159,
                'betriebskosten' => 9250,
                'instandhaltungskosten' => 10600,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'KSP-11 (Masch. 2)',
                'beschreibung' => '',
                'anschaffungswert' => 212000,
                'restbuchwert' => 10095,
                'wiederbeschaffungswert' => 514610,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 21,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 19080000,
                'kapazitaet_minute' => 159,
                'betriebskosten' => 9250,
                'instandhaltungskosten' => 10600,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'KSP-11 (Masch. 3)',
                'beschreibung' => '',
                'anschaffungswert' => 212000,
                'restbuchwert' => 10095,
                'wiederbeschaffungswert' => 514610,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 21,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 19080000,
                'kapazitaet_minute' => 159,
                'betriebskosten' => 9250,
                'instandhaltungskosten' => 10600,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'SP-250',
                'beschreibung' => '',
                'anschaffungswert' => 401518,
                'restbuchwert' => 19120,
                'wiederbeschaffungswert' => 974620,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 27,
                'anschlussleistung' => 30,
                'kapazitaet_jahr' => 15600000,
                'kapazitaet_minute' => 130,
                'betriebskosten' => 11900,
                'instandhaltungskosten' => 20075.90,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'SP-28',
                'beschreibung' => '',
                'anschaffungswert' => 750000,
                'restbuchwert' => 35714,
                'wiederbeschaffungswert' => 1820477,
                'beschaffungsjahr' => 2024,
                'nutzungsdauer' => 30,
                'raumbedarf' => 30,
                'anschlussleistung' => 30,
                'kapazitaet_jahr' => 14280000,
                'kapazitaet_minute' => 119,
                'betriebskosten' => 16400,
                'instandhaltungskosten' => 37500,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Presse',
                'bezeichnung' => 'SP-350',
                'beschreibung' => '',
                'anschaffungswert' => 615000,
                'restbuchwert' => 29286,
                'wiederbeschaffungswert' => 1492796,
                'beschaffungsjahr' => 2015,
                'nutzungsdauer' => 30,
                'raumbedarf' => 60,
                'anschlussleistung' => 45,
                'kapazitaet_jahr' => 12000000,
                'kapazitaet_minute' => 100,
                'betriebskosten' => 9700,
                'instandhaltungskosten' => 30750,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Abgratmaschine',
                'bezeichnung' => 'ME-2',
                'beschreibung' => '',
                'anschaffungswert' => 126000,
                'restbuchwert' => 6000,
                'wiederbeschaffungswert' => 305865,
                'beschaffungsjahr' => 2007,
                'nutzungsdauer' => 30,
                'raumbedarf' => 8,
                'anschlussleistung' => 14,
                'kapazitaet_jahr' => 2250000,
                'kapazitaet_minute' => 21,
                'betriebskosten' => 8100,
                'instandhaltungskosten' => 6300,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Abgratmaschine',
                'bezeichnung' => 'ME-2 V',
                'beschreibung' => '',
                'anschaffungswert' => 126000,
                'restbuchwert' => 6000,
                'wiederbeschaffungswert' => 305865,
                'beschaffungsjahr' => 2018,
                'nutzungsdauer' => 30,
                'raumbedarf' => 8,
                'anschlussleistung' => 14,
                'kapazitaet_jahr' => 2250000,
                'kapazitaet_minute' => 21,
                'betriebskosten' => 8100,
                'instandhaltungskosten' => 6300,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Gewinderollmaschine',
                'bezeichnung' => 'RP-21',
                'beschreibung' => '',
                'anschaffungswert' => 169000,
                'restbuchwert' => 8048,
                'wiederbeschaffungswert' => 410237,
                'beschaffungsjahr' => 2023,
                'nutzungsdauer' => 30,
                'raumbedarf' => 12,
                'anschlussleistung' => 14,
                'kapazitaet_jahr' => 15840000,
                'kapazitaet_minute' => 132,
                'betriebskosten' => 7100,
                'instandhaltungskosten' => 8450,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Gewinderollmaschine',
                'bezeichnung' => 'RP-32',
                'beschreibung' => '',
                'anschaffungswert' => 200000,
                'restbuchwert' => 9524,
                'wiederbeschaffungswert' => 485482,
                'beschaffungsjahr' => 2014,
                'nutzungsdauer' => 30,
                'raumbedarf' => 30,
                'anschlussleistung' => 13,
                'kapazitaet_jahr' => 16800000,
                'kapazitaet_minute' => 140,
                'betriebskosten' => 9100,
                'instandhaltungskosten' => 10000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Gewinderollmaschine',
                'bezeichnung' => 'GV-4',
                'beschreibung' => '',
                'anschaffungswert' => 100000,
                'restbuchwert' => 4762,
                'wiederbeschaffungswert' => 242756,
                'beschaffungsjahr' => 2008,
                'nutzungsdauer' => 30,
                'raumbedarf' => 20,
                'anschlussleistung' => 20,
                'kapazitaet_jahr' => 12120000,
                'kapazitaet_minute' => 101,
                'betriebskosten' => 8600,
                'instandhaltungskosten' => 5000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Gewinderollmaschine',
                'bezeichnung' => 'RP-420',
                'beschreibung' => '',
                'anschaffungswert' => 340000,
                'restbuchwert' => 16190,
                'wiederbeschaffungswert' => 825299,
                'beschaffungsjahr' => 2016,
                'nutzungsdauer' => 30,
                'raumbedarf' => 35,
                'anschlussleistung' => 18.5,
                'kapazitaet_jahr' => 5280000,
                'kapazitaet_minute' => 44,
                'betriebskosten' => 11900,
                'instandhaltungskosten' => 17000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Waschmaschine',
                'bezeichnung' => 'WM-1',
                'beschreibung' => '',
                'anschaffungswert' => 200000,
                'restbuchwert' => 9524,
                'wiederbeschaffungswert' => 485482,
                'beschaffungsjahr' => null,
                'nutzungsdauer' => 30,
                'raumbedarf' => 35,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 80000,
                'kapazitaet_minute' => 40,
                'betriebskosten' => 2882,
                'instandhaltungskosten' => 10000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Waschmaschine',
                'bezeichnung' => 'WM-2',
                'beschreibung' => '',
                'anschaffungswert' => 200000,
                'restbuchwert' => 9524,
                'wiederbeschaffungswert' => 485482,
                'beschaffungsjahr' => null,
                'nutzungsdauer' => 30,
                'raumbedarf' => 35,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 80000,
                'kapazitaet_minute' => 40,
                'betriebskosten' => 2882,
                'instandhaltungskosten' => 10000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Uldrian (Masch. 1)',
                'beschreibung' => '',
                'anschaffungswert' => 200000,
                'restbuchwert' => 9524,
                'wiederbeschaffungswert' => 485482,
                'beschaffungsjahr' => 2018,
                'nutzungsdauer' => 30,
                'raumbedarf' => 4.5,
                'anschlussleistung' => 12,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 10000,
                'instandhaltungskosten' => 10000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Uldrian (Masch. 2)',
                'beschreibung' => '',
                'anschaffungswert' => 200000,
                'restbuchwert' => 9524,
                'wiederbeschaffungswert' => 485482,
                'beschaffungsjahr' => 2018,
                'nutzungsdauer' => 30,
                'raumbedarf' => 4.5,
                'anschlussleistung' => 12,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 10000,
                'instandhaltungskosten' => 10000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Uldrian (Masch. 3)',
                'beschreibung' => '',
                'anschaffungswert' => 210000,
                'restbuchwert' => 10000,
                'wiederbeschaffungswert' => 509755,
                'beschaffungsjahr' => 2019,
                'nutzungsdauer' => 30,
                'raumbedarf' => 4.5,
                'anschlussleistung' => 12,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 10000,
                'instandhaltungskosten' => 10500,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Uldrian (Masch. 4)',
                'beschreibung' => '',
                'anschaffungswert' => 210000,
                'restbuchwert' => 10000,
                'wiederbeschaffungswert' => 509755,
                'beschaffungsjahr' => 2019,
                'nutzungsdauer' => 30,
                'raumbedarf' => 4.5,
                'anschlussleistung' => 12,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 10000,
                'instandhaltungskosten' => 10500,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Wolf (Masch. 5)',
                'beschreibung' => '',
                'anschaffungswert' => 250000,
                'restbuchwert' => 11905,
                'wiederbeschaffungswert' => 606846,
                'beschaffungsjahr' => null,
                'nutzungsdauer' => 30,
                'raumbedarf' => 4.5,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 10000,
                'instandhaltungskosten' => 12500,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Wolf (Masch. 6)',
                'beschreibung' => '',
                'anschaffungswert' => 250000,
                'restbuchwert' => 11905,
                'wiederbeschaffungswert' => 606846,
                'beschaffungsjahr' => null,
                'nutzungsdauer' => 30,
                'raumbedarf' => 4.5,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 10000,
                'instandhaltungskosten' => 12500,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Buchsenmaschine',
                'bezeichnung' => 'Uldrian (Masch. 7)',
                'beschreibung' => '',
                'anschaffungswert' => 275000,
                'restbuchwert' => 13095,
                'wiederbeschaffungswert' => 667527,
                'beschaffungsjahr' => null,
                'nutzungsdauer' => 30,
                'raumbedarf' => 10,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 40000,
                'kapazitaet_minute' => 20,
                'betriebskosten' => 11500,
                'instandhaltungskosten' => 13750,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Stangenlader',
                'bezeichnung' => 'TSM-22',
                'beschreibung' => '',
                'anschaffungswert' => 230000,
                'restbuchwert' => 10952,
                'wiederbeschaffungswert' => 558300,
                'beschaffungsjahr' => 2020,
                'nutzungsdauer' => 30,
                'raumbedarf' => 14,
                'anschlussleistung' => 15,
                'kapazitaet_jahr' => 20000,
                'kapazitaet_minute' => 10,
                'betriebskosten' => 20900,
                'instandhaltungskosten' => 11500,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'Stangenlader',
                'bezeichnung' => 'TSM-280',
                'beschreibung' => '',
                'anschaffungswert' => 200000,
                'restbuchwert' => 9524,
                'wiederbeschaffungswert' => 485482,
                'beschaffungsjahr' => null,
                'nutzungsdauer' => 30,
                'raumbedarf' => 14,
                'anschlussleistung' => 11,
                'kapazitaet_jahr' => 20000,
                'kapazitaet_minute' => 10,
                'betriebskosten' => 17900,
                'instandhaltungskosten' => 10000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name' => 'NC-Drehautomat',
                'bezeichnung' => 'Traub I',
                'beschreibung' => '',
                'anschaffungswert' => 360000,
                'restbuchwert' => 17143,
                'wiederbeschaffungswert' => 873844,
                'beschaffungsjahr' => 2018,
                'nutzungsdauer' => 30,
                'raumbedarf' => 40,
                'anschlussleistung' => 46,
                'kapazitaet_jahr' => 600000,
                'kapazitaet_minute' => 300,
                'betriebskosten' => 14950,
                'instandhaltungskosten' => 18000,
                'created_at' => date('Y-m-d H:i:s'),
            ],
        ]);
    }
}
