<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BikrKstAbteilungenSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('bikr_kst_abteilungen')->insert([
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'FiBu',
                'bezeichnung' => '100-Fibu',
                'beschreibung' => 'A-110',
                'type' => 'h',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s'),
                ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'IT',
                'bezeichnung' => '110-IT',
                'beschreibung' => 'A-120',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'HR',                  'bezeichnung' => '120-HR',                  'beschreibung' => 'A-130',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'EK',                  'bezeichnung' => '130-EK',                  'beschreibung' => 'A-140',
                'type' => 'h',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'Empfang',             'bezeichnung' => '140-Empfang',             'beschreibung' => 'A-150',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'Facility/Garten',     'bezeichnung' => '150-Facility/Garten',     'beschreibung' => 'A-160',
                'type' => 'h',
                'personal' => 4,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'Personalbuchhaltung',
                'bezeichnung' => '160-Personalbuchhaltung',
                'beschreibung' => 'A-170',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 1,
                'abteilung' => 'Controlling',         'bezeichnung' => '170-Controlling',         'beschreibung' => 'A-180',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 2,
                'abteilung' => 'S-100',           'bezeichnung' => 'S 100-Ltg.',          'beschreibung' => 'S-100',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 2,
                'abteilung' => 'Service Technik',
                'bezeichnung' => '200-Service Technik',
                'beschreibung' => 'S-120',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 2,
                'abteilung' => 'Reparatur',       'bezeichnung' => '210-Reparatur',       'beschreibung' => 'S-130',
                'type' => 'k',
                'personal' => 3,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 2,
                'abteilung' => 'Verkauf',         'bezeichnung' => '220-Verkauf',         'beschreibung' => 'S-140',
                'type' => 'h',
                'personal' => 3,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 2,
                'abteilung' => 'Aussendienst',    'bezeichnung' => '230-Aussendienst',    'beschreibung' => 'S-150',
                'type' => 'k',
                'personal' => 3,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 2,
                'abteilung' => 'Export & Zoll',   'bezeichnung' => '240-Export & Zoll',   'beschreibung' => 'S-170',
                'type' => 'h',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 3,
                'abteilung' => 'Elektro',  'bezeichnung' => '310-Elektro',  'beschreibung' => 'E-110',
                'type' => 'h',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 3,
                'abteilung' => 'Mechanik',
                'bezeichnung' => '320-Mechanik',
                'beschreibung' => 'E-120',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 3,
                'abteilung' => 'CAD',      'bezeichnung' => '330-CAD',      'beschreibung' => 'E-130',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 3,
                'abteilung' => 'CNC',      'bezeichnung' => '340-CNC',      'beschreibung' => 'E-140',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 4,
                'abteilung' => 'SE',       'bezeichnung' => '400-Produktion-Schweisselemente',
                'beschreibung' => 'P-110',
                'type' => 'k',
                'personal' => 7,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 4,
                'abteilung' => 'Mechanik',
                'bezeichnung' => '430-Produktion-Mechanik',         'beschreibung' => 'P-140',
                'type' => 'k',
                'personal' => 3,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 4,
                'abteilung' => 'Geräte',   'bezeichnung' => '410-Produktion-Geräte',           'beschreibung' => 'P-120',
                'type' => 'k',
                'personal' => 6,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 4,
                'abteilung' => 'Pistolen',
                'bezeichnung' => '420-Produktion-Pistolen',         'beschreibung' => 'P-130',
                'type' => 'k',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 4,
                'abteilung' => 'CNC',      'bezeichnung' => '440-Produktion-CNC',              'beschreibung' => 'P-150',
                'type' => 'k',
                'personal' => 4,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 4,
                'abteilung' => 'AV',       'bezeichnung' => '450-Produktion-AV',               'beschreibung' => 'P-160',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 5,
                'abteilung' => 'M-100',            'bezeichnung' => '500-Ltg.',             'beschreibung' => 'M-100',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 5,
                'abteilung' => 'Webseite/Shop',    'bezeichnung' => '510-Webseite/Shop',    'beschreibung' => 'M-110',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 5,
                'abteilung' => 'techn. Doku.',     'bezeichnung' => '520-techn.Doku.',      'beschreibung' => 'M-120',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 5,
                'abteilung' => 'Online-Marketing',
                'bezeichnung' => '530-Online-Marketing',
                'beschreibung' => 'M-130',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 6,
                'abteilung' => 'IMS-100',    'bezeichnung' => 'IMS 100-Ltg.',   'beschreibung' => 'IMS-100',
                'type' => 'h',
                'personal' => 3,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 6,
                'abteilung' => 'WE Prüfung',
                'bezeichnung' => '600-WE Prüfung',
                'beschreibung' => 'IMS-110',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 6,
                'abteilung' => 'Prüfmittel',
                'bezeichnung' => '610-Prüfmittel',
                'beschreibung' => 'IMS-120',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 6,
                'abteilung' => 'Audit-Team',
                'bezeichnung' => '620-Audit-Team',
                'beschreibung' => 'IMS-130',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 6,
                'abteilung' => 'Projekte',   'bezeichnung' => '630-Projekte',   'beschreibung' => 'IMS-140',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 6,
                'abteilung' => 'WA Prüfung',
                'bezeichnung' => '640-WA Prüfung',
                'beschreibung' => 'IMS-150',
                'type' => 'h',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 7,
                'abteilung' => 'LLV-100',          'bezeichnung' => 'LLV 100-Ltg.',         'beschreibung' => 'LLV-100',
                'type' => 'k',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 7,
                'abteilung' => 'Lager Geräte',     'bezeichnung' => '700-Lager Geräte',     'beschreibung' => 'LLV-110',
                'type' => 'k',
                'personal' => 1,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 7,
                'abteilung' => 'Lager SE',         'bezeichnung' => '710-Lager SE',         'beschreibung' => 'LLV-120',
                'type' => 'k',
                'personal' => 3,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 7,
                'abteilung' => 'Lager Produktion',
                'bezeichnung' => '730-Lager Produktion',
                'beschreibung' => 'LLV-130',
                'type' => 'k',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 7,
                'abteilung' => 'Logistik',         'bezeichnung' => '740-Logistik',         'beschreibung' => 'LLV-140',
                'type' => 'k',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'bikr_kst_bereiche_id' => 7,
                'abteilung' => 'Portionierung',    'bezeichnung' => '750-Portionierung',    'beschreibung' => 'LLV-150',
                'type' => 'h',
                'personal' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ],

            [
                'bikr_kst_bereiche_id' => 8,
                'abteilung' => 'IMS Stab',
                'bezeichnung' => '900-IMS-Stab',
                'beschreibung' => 'GL-110',
                'type' => 'h',
                'personal' => 2,
                'created_at' => date('Y-m-d H:i:s')
            ],

        ]);
    }
}
