<?php

return [
    'name' => 'Neo',
    'title' => 'Neo',
    'subtitle' => 'Nova Extension Objects',
    'namespace' => 'App\Modules\Neo',
    'version' => '1.0.0',
    'navigation' => [
        'meta' => [
            'name' => 'Neo',
            'desc' => 'Nova Extension Objects',
            'link' => '/neo',
            'permissions' => true,
            'icon' => 'fa-globe-europe'
        ],
        'functions' => [
            'stammdaten' => [
                'meta' => [
                    'name' => 'Stammdaten',
                    'desc' => 'Artikel, Stücklisten, Arbeitsgänge und Bestände, Verweise zu Vorgängen (Einkauf / Verkauf / Fertigung)',
                    'link' => '/neo/stammdaten',
                    'permissions' => true,
                    'icon' => 'fa-landmark',
                    'disabled' => true,

                ],
                'functions' => [
                    'artikel' => [
                        'meta' => [
                            'name' => 'Artikel',
                            'desc' => 'Artikel, Teile, Baugruppen, Stoffe Auskunft',
                            'link' => '/neo/stammdaten/artikel',
                            'permissions' => true,
                            'icon' => 'fa-boxes',
                            'disabled' => true,
                        ]
                    ],
                    'kunden' => [
                        'meta' => [
                            'name' => 'Kunden',
                            'desc' => 'Kunden Auskunft',
                            'link' => '/neo/stammdaten/kunden',
                            'permissions' => true,
                            'icon' => 'fa-users',
                            'disabled' => true,
                        ]
                    ],
                    'lieferanten' => [
                        'meta' => [
                            'name' => 'Lieferanten',
                            'desc' => 'Lieferanten Auskunft',
                            'link' => '/neo/stammdaten/lieferanten',
                            'permissions' => true,
                            'icon' => 'fa-shopping-basket',
                            'disabled' => true,
                        ]
                    ],
                    'lager' => [
                        'meta' => [
                            'name' => 'Lager',
                            'desc' => 'Lager, Lager und Verkauf',
                            'link' => '/neo/stammdaten/lager',
                            'permissions' => true,
                            'icon' => 'fa-warehouse',
                            'disabled' => true,
                        ]
                    ],
                    'maschinen' => [
                        'meta' => [
                            'name' => 'Maschinen',
                            'desc' => 'Maschinen Auskunft',
                            'link' => '/neo/stammdaten/maschinen',
                            'permissions' => true,
                            'icon' => 'fa-robot',
                            'disabled' => true,
                        ]
                    ],
                    'personal' => [
                        'meta' => [
                            'name' => 'Personal',
                            'desc' => 'Personal Auskunft',
                            'link' => '/neo/stammdaten/personal',
                            'permissions' => true,
                            'icon' => 'fa-user',
                            'disabled' => true,
                        ]
                    ]
                ]
            ],
            'ek' => [
                'meta' => [
                    'name' => 'Einkauf',
                    'desc' => 'Artikeldaten, Lieferanten und Bestellungen',
                    'link' => '/neo/ek',
                    'permissions' => true,
                    'icon' => 'fa-shopping-cart',
                    'disabled' => true,
                ],
                'functions' => [
                    'lieferanten' => [
                        'meta' => [],
                        'functions' => []
                    ],
                    'einkaufsteile' => [
                        'meta' => [],
                        'functions' => []
                    ],
                    'referenzteile' => [
                        'meta' => [],
                        'functions' => []
                    ],
                    'anfragen' => [
                        'meta' => [],
                        'functions' => []
                    ],
                    'bestellungen' => [
                        'meta' => [],
                        'functions' => []
                    ],
                    'we-lieferscheine' => [
                        'meta' => [],
                        'functions' => []
                    ],
                ]
            ],
            'vk' => [
                'meta' => [
                    'name' => 'Verkauf',
                    'desc' => 'Artikeldaten, Kunden und Aufträge',
                    'link' => '/neo/vk',
                    'permissions' => true,
                    'icon' => 'fa-truck',
                    'disabled' => true,
                ],
                'functions' => []
            ],
            'lager' => [
                'meta' => [
                    'name' => 'Lager',
                    'desc' => 'Artikeldaten, Lagerorte, Lagerplätze, Lagerbewegungen',
                    'link' => '/neo/lager',
                    'permissions' => true,
                    'icon' => 'fa-boxes',
                    'disabled' => true,
                ],
                'functions' => []
            ],
            'fertigung' => [
                'meta' => [
                    'name' => 'Fertigung',
                    'desc' => 'Fertigungsaufträge, Maschinen, Auslastung',
                    'link' => '/neo/fertigung',
                    'permissions' => true,
                    'icon' => 'fa-sitemap',
                    'disabled' => true,
                ],
                'functions' => []
            ],
        ]
    ]
];
