<?php

namespace App\modules\Neo\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Core\Traits\ModuleHelperTrait;

class NeoController extends Controller
{
    use ModuleHelperTrait;

    public function index()
    {
        $moduleInfo = $this->getModuleNavigationInfo(['neo']);
        $neoModul = $moduleInfo['activeModules']['neo'];
        return view('core::modulelist', ['moduleInfo' => $neoModul]);
    }

    /**
     * STAMMDATEN BEREICH
     */

    public function stammdaten()
    {
        $moduleInfo = $this->getModuleNavigationInfo(['neo']);
        $neoModul = $moduleInfo['activeModules']['neo']['functions']['stammdaten'];
        return view('core::fnlist', ['moduleInfo' => $neoModul]);
    }


    public function stammdatenArtikelSuchmaske()
    {
        return view('neo::stammdaten.artikel.suchmaske');
    }


}
