<?php

use App\modules\Mis\Controllers\MisAbteilungenController;
use App\modules\Mis\Controllers\MisController;
use App\modules\Mis\Controllers\MisKostenstellenController;
use App\modules\Mis\Controllers\MisKostentraegerController;
use App\modules\Mis\Controllers\MisLohnkostenController;
use App\modules\Mis\Controllers\StatEinkaufController;
use App\modules\Mis\Controllers\StatVerkaufController;
use Illuminate\Support\Facades\Route;

/**
 * Routing Conventions:
 * GET    maschine                 => index
 * GET    maschine/create          => create
 * GET    maschine/{maschine}      => show
 * GET    maschine/{maschine}/edit => edit
 * POST   maschine                 => store
 * PATCH  maschine/{maschine}      => update
 * DELETE maschine/{maschine}      => update
 *
 * TODO: separate into new Controller MisController is only for Modulnavigation
 */

Route::middleware('auth')->group(function () {
    Route::get('/mis', [MisController::class, 'index']);

    Route::get('/mis/stat', [MisController::class, 'stat']);
    Route::get('/mis/stat/ek', [MisController::class, 'statEinkauf']);
    Route::get('/mis/stat/vk', [MisController::class, 'statVerkauf']);
    Route::get('/mis/stat/bestand', [MisController::class, 'statBestand']);

    Route::get('/mis/klr', [MisController::class, 'klr']);
    Route::get('/mis/klr/stammdaten', [MisController::class, 'klrStammdaten']);
    Route::get('/mis/klr/maschinenkalkulation', [MisController::class, 'klrMaschinenkalkulation']);
    Route::get('/mis/klr/produktkosten', [MisController::class, 'klrProduktlinienkalkulation']);
    Route::get('/mis/klr/aufschlagskalkulation', [MisController::class, 'klrAufschlagskalkulation']);
    Route::get('/mis/klr/rentabilitaet', [MisController::class, 'klrRentabilitaet']);


    Route::get('/mis/klr/stammdaten/bilanz', [MisController::class, 'klrStammBilanzIndex'])->name('mis.klr.stammdaten.bilanz');
    Route::get('/mis/klr/stammdaten/bilanz/create', [MisController::class, 'klrStammBilanzCreate']);
    Route::get('/mis/klr/stammdaten/bilanz/{bilanz}', [MisController::class, 'klrStammBilanzShow']);
    Route::get('/mis/klr/stammdaten/bilanz/{bilanz}/edit', [MisController::class, 'klrStammBilanzEdit']);
    Route::get('/mis/klr/stammdaten/bilanz/{bilanz}/delete', [MisController::class, 'klrStammBilanzDelete']);
    Route::post('/mis/klr/stammdaten/bilanz', [MisController::class, 'klrStammBilanzStore']);
    Route::patch('/mis/klr/stammdaten/bilanz/{bilanz}', [MisController::class, 'klrStammBilanzUpdate']);


    Route::get('/mis/klr/stammdaten/maschine', [MisController::class, 'klrStammMaschineIndex'])->name('mis.klr.stammdaten.maschine');
    Route::get('/mis/klr/stammdaten/maschine/create', [MisController::class, 'klrStammMaschineCreate']);
    Route::get('/mis/klr/stammdaten/maschine/{maschine}', [MisController::class, 'klrStammMaschineShow']);
    Route::get('/mis/klr/stammdaten/maschine/{maschine}/edit', [MisController::class, 'klrStammMaschineEdit']);
    Route::post('/mis/klr/stammdaten/maschine', [MisController::class, 'klrStammMaschineStore']);
    Route::patch('/mis/klr/stammdaten/maschine/{maschine}', [MisController::class, 'klrStammMaschineUpdate']);


    Route::get('/mis/klr/stammdaten/parameter', [MisController::class, 'klrStammParamIndex'])->name('mis.klr.stammdaten.parameter');
    Route::get('/mis/klr/stammdaten/parameter/create', [MisController::class, 'klrStammParamCreate']);
    Route::get('/mis/klr/stammdaten/parameter/{parameter}', [MisController::class, 'klrStammParamShow']);
    Route::get('/mis/klr/stammdaten/parameter/{parameter}/edit', [MisController::class, 'klrStammParamEdit']);
    Route::post('/mis/klr/stammdaten/parameter', [MisController::class, 'klrStammParamStore']);
    Route::patch('/mis/klr/stammdaten/parameter/{parameter}', [MisController::class, 'klrStammParamUpdate']);


    Route::get('/mis/klr/maschinenkalkulation/datenblatt', [MisController::class, 'klrMaschinenkalkulationDatenblattIndex']);
    Route::get('/mis/klr/maschinenkalkulation/datenblaetter', [MisController::class, 'klrMaschinenkalkulationDatenblaetterIndex']);
    Route::get('/mis/klr/maschinenkalkulation/datenblatt/{maschine}', [MisController::class, 'klrMaschinenkalkulationDatenblattShow']);
    Route::get('/mis/klr/maschinenkalkulation/berechnen/{maschine}', [MisController::class, 'klrMaschinenkalkulationBerechnen']);
    Route::get('/mis/klr/maschinenkalkulation/berechnen', [MisController::class, 'klrMaschinenkalkulationBerechnenAll']);


    Route::get('/mis/klr/stammdaten/kostenstelle/structure', [MisKostenstellenController::class, 'showStructure']);
    Route::get('/mis/klr/stammdaten/kostenstelle', [MisKostenstellenController::class, 'index'])->name('mis.klr.stammdaten.kostenstelle');
    Route::get('/mis/klr/stammdaten/kostenstelle/create', [MisKostenstellenController::class, 'create']);
    Route::get('/mis/klr/stammdaten/kostenstelle/{kstBereich}', [MisKostenstellenController::class, 'show'])->name('mis.klr.stammdaten.kostenstelle.show');
    Route::get('/mis/klr/stammdaten/kostenstelle/{kstBereich}/edit', [MisKostenstellenController::class, 'edit']);
    Route::get('/mis/klr/stammdaten/kostenstelle/{kstBereich}/delete', [MisKostenstellenController::class, 'delete']);
    Route::post('/mis/klr/stammdaten/kostenstelle', [MisKostenstellenController::class, 'store']);
    Route::patch('/mis/klr/stammdaten/kostenstelle/{kstBereich}', [MisKostenstellenController::class, 'update']);


    Route::get('/mis/klr/stammdaten/kostenstelle/{kstBereich}/abteilung/create', [MisAbteilungenController::class, 'create']);
    Route::get('/mis/klr/stammdaten/abteilung/{abteilung}', [MisAbteilungenController::class, 'show']);
    Route::get('/mis/klr/stammdaten/abteilung/{abteilung}/edit', [MisAbteilungenController::class, 'edit']);
    Route::get('/mis/klr/stammdaten/abteilung/{abteilung}/delete', [MisAbteilungenController::class, 'delete']);
    Route::post('/mis/klr/stammdaten/abteilung', [MisAbteilungenController::class, 'store']);
    Route::patch('/mis/klr/stammdaten/abteilung/{abteilung}', [MisAbteilungenController::class, 'update']);


    Route::get('/mis/klr/stammdaten/kostentraeger/structure', [MisKostentraegerController::class, 'showStructure']);
    Route::get('/mis/klr/stammdaten/kostentraeger', [MisKostentraegerController::class, 'index'])->name('mis.klr.stammdaten.kostentraeger');
    Route::get('/mis/klr/stammdaten/kostentraeger/create', [MisKostentraegerController::class, 'create']);
    Route::get('/mis/klr/stammdaten/kostentraeger/{kt}', [MisKostentraegerController::class, 'show'])->name('mis.klr.stammdaten.kostentraeger.show');
    Route::get('/mis/klr/stammdaten/kostentraeger/{kt}/edit', [MisKostentraegerController::class, 'edit']);
    Route::get('/mis/klr/stammdaten/kostentraeger/{kt}/delete', [MisKostentraegerController::class, 'delete']);
    Route::post('/mis/klr/stammdaten/kostentraeger', [MisKostentraegerController::class, 'store']);
    Route::patch('/mis/klr/stammdaten/kostentraeger/{kt}', [MisKostentraegerController::class, 'update']);

    Route::get('/mis/klr/stammdaten/lohnkosten', [MisLohnkostenController::class, 'index']);
    Route::get('/mis/klr/stammdaten/lohnkosten/jahr/{id}', [MisLohnkostenController::class, 'show']);
    Route::match(['get','post'], '/mis/klr/stammdaten/lohnkosten/{jahr}/edit', [MisLohnkostenController::class, 'edit']);
    Route::match(['get','post'], '/mis/klr/stammdaten/lohnkosten/{jahr}/delete', [MisLohnkostenController::class, 'delete']);
    Route::get('/mis/klr/stammdaten/lohnkosten/create', [MisLohnkostenController::class, 'create']);
    Route::get('/mis/klr/stammdaten/lohnkosten/create_step_b', [MisLohnkostenController::class, 'create_step_b']);
    Route::post('/mis/klr/stammdaten/lohnkosten', [MisLohnkostenController::class, 'store']);
    Route::post('/mis/klr/stammdaten/lohnkosten/abt', [MisLohnkostenController::class, 'store_abt']);
    Route::patch('/mis/klr/stammdaten/lohnkosten/update', [MisLohnkostenController::class, 'update']);
    Route::patch('/mis/klr/stammdaten/lohnkosten/abt/update', [MisLohnkostenController::class, 'update_abt']);

    Route::get('/mis/klr/stammdaten/kostentraeger/{kt}/produkt/create', [MisKostentraegerController::class, 'createProduct']);
    Route::post('/mis/klr/stammdaten/kostentraeger/produkt', [MisKostentraegerController::class, 'storeProdukt']);
    Route::get('/mis/klr/stammdaten/kostentraeger/produkt/{prod}', [MisKostentraegerController::class, 'showProdukt']);
    Route::get('/mis/klr/stammdaten/kostentraeger/produkt/{prod}/create_artikel', [MisKostentraegerController::class, 'createArtikel'])->name('mis.klr.stammdaten.kostentraeger.create_artikel');

    /**
     * Auswertungen VK
     */

    Route::get('/mis/stat/vk/rgjournal', [StatVerkaufController::class, 'rgjournal']);
    Route::get('/mis/stat/vk/rgjournal_kd/{kdid}', [StatVerkaufController::class, 'rgjournal_kd']);
    Route::get('/mis/stat/vk/rgjournal_request', [StatVerkaufController::class, 'rgjournal_request']);

    Route::get('/mis/stat/vk/kunden', [StatVerkaufController::class, 'kunden']);
    Route::match(['get','post'], '/mis/stat/vk/kunden_request', [StatVerkaufController::class, 'kunden_request']);

    Route::get('/mis/stat/ek/lieferant', [StatEinkaufController::class, 'lieferant']);
    Route::post('/mis/stat/ek/lieferant', [StatEinkaufController::class, 'lieferant_request']);

});
