<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/parameter">
    @csrf

    <x-core::pagesections.pagetitle subtitle="Parameter Information">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Daten des Parameter" subtitle="Parameter-ID {{ $parameter->id }}" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info name="name" size="30" value="{{ $parameter->name }}" />
            <x-safweb.forms.info name="bezeichnung" size="30" value="{{ $parameter->bezeichnung }}" />
            <x-safweb.forms.info name="beschreibung" cols="30" rows="4" value="{{ $parameter->beschreibung }}"/>
            <x-safweb.forms.info format="number" name="value_numeric" size="10" label="Wert" value="{{ $parameter->value_numeric }}"/>
            <x-safweb.forms.info name="value_string" size="10" label="Text" value="{{ $parameter->value_string }}"/>
            <x-safweb.forms.info format="date" name="created_at" size="10" label="angelegt am" value="{{ $parameter->created_at }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $parameter->changed_at }}"/>

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <a href="/mis/klr/stammdaten/parameter/{{ $parameter->id }}/edit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">bearbeiten<i class="fa fa-pencil-alt ml-2"></i></a>
    </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
