<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/parameter/{{ $parameter->id }}">
    @csrf
    @method('PATCH')

    <x-core::pagesections.pagetitle subtitle="Parameter bearbeiten">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Parameter bearbeiten" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.input autofocus tabindex="1" name="name" size="30" value="{{ $parameter->name }}" />
            <x-safweb.forms.input tabindex="2" name="bezeichnung" size="30" value="{{ $parameter->bezeichnung }}" />
            <x-safweb.forms.textarea tabindex="3" name="beschreibung" cols="30" rows="4" :value="$parameter->beschreibung"/>
            <x-safweb.forms.input tabindex="5" name="value_numeric" size="10" label="Wert" value="{{ $parameter->value_numeric }}" />
            <x-safweb.forms.input tabindex="6" name="value_string" size="20" label="Text" value="{{  $parameter->value_string }}" />

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
        <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
    </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
