<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/maschine">
    @csrf

    <x-core::pagesections.pagetitle subtitle="Maschine Information">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Daten der Maschine" subtitle="Maschinen-ID {{ $maschine->id }}" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info name="name" size="30" value="{{ $maschine->name }}" />
            <x-safweb.forms.info name="bezeichnung" size="30" value="{{ $maschine->bezeichnung }}" />
            <x-safweb.forms.info name="beschreibung" cols="30" rows="4" value="{{ $maschine->beschreibung }}"/>
            <x-safweb.forms.info format="currency" name="anschaffungswert" size="10" label="Anschaffungswert in €" value="{{ $maschine->anschaffungswert }}"/>
            <x-safweb.forms.info format="currency" name="restbuchwert" size="10" label="Restbuchwert in €" value="{{ $maschine->restbuchwert }}"/>
            <x-safweb.forms.info format="currency" name="wiederbeschaffungswert" size="10" label="Wiederbeschaffungswert in €" value="{{ $maschine->wiederbeschaffungswert }}"/>
            <x-safweb.forms.info format="year" name="beschaffungsjahr" size="10" value="{{ $maschine->beschaffungsjahr }}"/>
            <x-safweb.forms.info name="nutzungsdauer" size="10" label="Nutzungsdauer (Jahre)" value="{{ $maschine->nutzungsdauer }}"/>
            <x-safweb.forms.info name="raumbedarf" size="10" label="Raumbedarf (m<sup>2</sup>)" value="{{ $maschine->raumbedarf }}"/>
            <x-safweb.forms.info name="anschlussleistung" size="10" label="Anschlussleistung (kw)" value="{{ $maschine->anschlussleistung }}"/>
            <x-safweb.forms.info format="number" name="kapazitaet_jahr" size="10" label="Kapazität (pro Jahr)" value="{{ $maschine->kapazitaet_jahr }}"/>
            <x-safweb.forms.info format="number" name="kapazitaet_minute" size="10" label="Kapazität (pro Minute)" value="{{ $maschine->kapazitaet_minute }}"/>
            <x-safweb.forms.info format="currency" name="betriebskosten" size="10" label="Betriebskosten in €" value="{{ $maschine->betriebskosten }}"/>
            <x-safweb.forms.info format="currency" name="instandhaltungskosten" size="10" label="Instandhaltungskosten in €" value="{{ $maschine->instandhaltungskosten }}"/>
            <x-safweb.forms.info format="number,2" name="ms_faktor" size="10" label="MS Faktor" value="{{ $maschine->ms_faktor }}"/>
            <x-safweb.forms.info name="faktor_beschreibung"  label="MS Faktor Beschreibung" value="{{ $maschine->faktor_beschreibung }}"/>
            <x-safweb.forms.info format="date" name="created_at" size="10" label="angelegt am" value="{{ $maschine->created_at }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $maschine->changed_at }}"/>

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <a href="/mis/klr/stammdaten/maschine/{{ $maschine->id }}/edit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">bearbeiten<i class="fa fa-pencil-alt ml-2"></i></a>
    </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
