<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/maschine">
    @csrf

    <x-core::pagesections.pagetitle subtitle="Maschine erfassen">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="neue Maschine anlegen" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.input autofocus tabindex="1" name="name" size="30" />
            <x-safweb.forms.input tabindex="2" name="bezeichnung" size="30" />
            <x-safweb.forms.textarea tabindex="3" name="beschreibung" cols="30" rows="4" value="{{ old('beschreibung') }}"/>
            <x-safweb.forms.input tabindex="4" name="anschaffungswert" size="10" label="Anschaffungswert in €" placeholder="0,00" />
            <x-safweb.forms.input tabindex="5" name="restbuchwert" size="10" label="Restbuchwert in €" placeholder="0,00" />
            <x-safweb.forms.input tabindex="6" name="wiederbeschaffungswert" size="10" label="Wiederbeschaffungswert in €" placeholder="0,00" />
            <x-safweb.forms.input tabindex="7" name="beschaffungsjahr" size="10" placeholder="2010" />
            <x-safweb.forms.input tabindex="8" name="nutzungsdauer" size="10" label="Nutzungsdauer (Jahre)" placeholder="20" />
            <x-safweb.forms.input tabindex="9" name="raumbedarf" size="10" label="Raumbedarf (m<sup>2</sup>)" placeholder="15" />
            <x-safweb.forms.input tabindex="10" name="anschlussleistung" size="10" label="Anschlussleistung (kw)" placeholder="7,5" />
            <x-safweb.forms.input tabindex="11" name="kapazitaet" size="10" label="Kapazität (pro Jahr)" placeholder="100000" />
            <x-safweb.forms.input tabindex="12" name="betriebskosten" size="10" label="Betriebskosten in €" placeholder="0,00" />
            <x-safweb.forms.input tabindex="13" name="instandhaltungskosten" size="10" label="Instandhaltungskosten in €" placeholder="0,00" />
            <x-safweb.forms.input tabindex="14" name="ms_faktor" size="10" label="MS Faktor" placeholder="0,08" />
            <x-safweb.forms.textarea tabindex="15" name="faktor_beschreibung" cols="30" rows="4" label="MS Faktor Beschreibung" value="{{ old('faktor_beschreibung') }}" />

        </div>

        <div class="hidden m-1 bg-gray-200 grid grid-cols-[auto_4fr_auto] gap-0">
            <div class="p-1 bg-ctrl-tbl-blue">Gültigkeit</div>
            <div class=""> <input class="w-full ml-1 p-1 text-sm font-mono border-[1px] border-blue-900" id="f3" name="safdetail[gueltigkeit]" placeholder="" readonly="1" size="14" type="input" value="0" label="Gültigkeit"> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer"><i class="fa fa-ellipsis-v"></i></div>

            <div class="p-1 bg-ctrl-tbl-blue">Nachfassen</div>
            <div class=""> <input class="w-full ml-1 p-1 text-sm font-mono border-[1px] border-blue-900" id="f4" name="safdetail[nachfassen]" placeholder="" readonly="1" size="14" type="input" value="0" label="Nachfassen"> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer"><i class="fa fa-ellipsis-v"></i></div>

            <div class="p-1 bg-ctrl-tbl-blue">Nachfassen</div>
            <div class=""> <input class="w-full ml-1 p-1 text-sm font-mono border-[1px] border-blue-900" id="f4" name="safdetail[nachfassen]" placeholder="" readonly="1" size="14" type="input" value="0" label="Nachfassen"> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer"><i class="fa fa-ellipsis-v"></i></div>

            <!-- Spacer Component -->
            <div class="p-1 bg-ctrl-tbl-blue"></div>
            <div class=""> <span class="w-full ml-1 p-1"></span> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer">&nbsp;</div>

            <!-- Spacer Component -->
            <div class="p-1 bg-ctrl-tbl-blue"></div>
            <div class=""> <span class="w-full ml-1 p-1"></span> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer">&nbsp;</div>

            <div class="p-1 bg-ctrl-tbl-blue">Nachfassen</div>
            <div class=""> <input class="w-full ml-1 p-1 text-sm font-mono border-[1px] border-blue-900" id="f4" name="safdetail[nachfassen]" placeholder="" readonly="1" size="14" type="input" value="0" label="Nachfassen"> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer"><i class="fa fa-ellipsis-v"></i></div>

            <div class="p-1 bg-ctrl-tbl-blue">Nachfassen</div>
            <div class=""> <input class="w-full ml-1 p-1 text-sm font-mono border-[1px] border-blue-900" id="f4" name="safdetail[nachfassen]" placeholder="" readonly="1" size="14" type="input" value="0" label="Nachfassen"> </div>
            <div class="p-1 mx-2 text-center hover:cursor-pointer"><i class="fa fa-ellipsis-v"></i></div>

        </div>

    </div>

    <x-safweb.pagesections.pagecontrol>
        <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
        <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
    </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
