^<x-layout>
    <x-core::pagesections.pagetitle subtitle="Lohnkosten für {{ $jahr }}">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
{{--        <x-safweb.components.pagetopnav-spacer />--}}
{{--        <span class="inline-block my-1">--}}
{{--            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 22 22"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-circle-number-1"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /><path d="M10 10l2 -2v8" /></svg>--}}
{{--        </span>--}}
    </x-safweb.pagesections.pagetopnav>


    <form method="POST" action="/mis/klr/stammdaten/lohnkosten/{{$jahr}}/edit">
        @csrf
        @method('POST')

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">
            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <x-safweb.forms.input readonly name="jahr" size="10" value="{{ $jahr }}" />
                <x-safweb.forms.input readonly name="option" label="Erfassen für" size="10" value="{{ $option }}" />
            </div>
        </div>


        <!-- FORM Grid -->
        <div class="w-2/3 md:w-1/2 py-4">
            <div class="grid grid-cols-[2fr_3fr_2fr_2fr_2fr] gap-1">
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Bereich</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Abteilung</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Lohn</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Gehalt</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Sozialabgaben</div>

                @php
                    $s_lohn = 0;;
                    $s_gehalt = 0;
                    $s_sozial = 0;
                    $abt = '';
                    $abtStr = '';
                    $bg = '';
                @endphp

                @foreach($data as $record)
                    @php
                        $s_lohn += $record->lohn;
                        $s_gehalt += $record->gehalt;
                        $s_sozial += $record->sozial;
                        $abtStr = '';
                        $bg = '';
                        if ($abt != $record->bereich->bezeichnung) {
                            $abtStr = $record->bereich->bezeichnung;
                            $abt = $record->bereich->bezeichnung;
                            $bg = ' bg-ctrl-tbl-blue ';
                        }
                    @endphp
                    <div class="p-1 {{ $bg }} font-bold">{{ $abtStr }}</div>
                    <div class="p-1 bg-ctrl-tbl-blue text-sm">{{ $record->abteilung->bezeichnung }}</div>
                    <div class="px-2">
                        <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">
                            {{ number_format(round((float) $record->lohn, 2),2, ',', '.'). "€" }}
                        </p>
                    </div>
                    <div class="px-2">
                        <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">
                            {{ number_format(round((float) $record->gehalt, 2),2, ',', '.'). "€" }}
                        </p>
                    </div>
                    <div class="px-2">
                        <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">
                            {{ number_format(round((float) $record->sozialbagaben, 2),2, ',', '.'). "€" }}
                        </p>
                    </div>
                @endforeach

                <div class="p-1 bg-ctrl-tbl-blue font-bold col-span-2">Summen</div>
                <div class="px-2 bg-ctrl-tbl-blue font-bold">
                    <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">
                        {{ number_format(round((float) $s_lohn, 2),2, ',', '.'). "€" }}
                    </p>
                </div>
                <div class="px-2 bg-ctrl-tbl-blue font-bold">
                    <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">
                        {{ number_format(round((float) $s_gehalt, 2),2, ',', '.'). "€" }}
                    </p>
                </div>
                <div class="px-2 bg-ctrl-tbl-blue font-bold">
                    <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">
                        {{ number_format(round((float) $s_sozial, 2),2, ',', '.'). "€" }}
                    </p>

                </div>

            </div>
        </div>
        <x-safweb.pagesections.pagecontrol class="mt-2">
            <a onclick="return window.confirm('Diesen Satz wirklich löschen?')" href="/mis/klr/stammdaten/lohnkosten/{{ $jahr }}/delete" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-red text-white hover:bg-red-400">löschen<i class="fa fa-trash ml-2"></i></a>
            <button type="submit" tabindex="3" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">bearbeiten<i class="fa fa-pen ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

</x-layout>
