<x-layout>
    <x-core::pagesections.pagetitle subtitle="Lohnkosten bearbeiten für {{ $jahr }}">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
{{--        <x-safweb.components.pagetopnav-spacer />--}}
{{--        <span class="inline-block my-1">--}}
{{--            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 22 22"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-circle-number-1"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /><path d="M10 10l2 -2v8" /></svg>--}}
{{--        </span>--}}
    </x-safweb.pagesections.pagetopnav>


    <form method="POST" action="/mis/klr/stammdaten/lohnkosten/update">
        @csrf
        @method('PATCH')
        <input type="hidden" name="jahr" value="{{ $jahr }}">

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">
            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <x-safweb.forms.input readonly name="jahr" size="10" value="{{ $jahr }}" />
                <x-safweb.forms.input readonly name="option" label="Erfassen für" size="10" value="{{ $option }}" />
            </div>
        </div>


        <!-- FORM Grid -->
        <div class="w-2/3 md:w-1/2 py-4">
            <div class="grid grid-cols-[1fr_2fr_2fr_2fr] gap-0">
                <div class="p-1 bg-ctrl-tbl-blue">Bereich</div>
                <div class="p-1 bg-ctrl-tbl-blue">Lohn</div>
                <div class="p-1 bg-ctrl-tbl-blue">Gehalt</div>
                <div class="p-1 bg-ctrl-tbl-blue">Sozialabgaben</div>
                @php
                    $s_lohn = 0;;
                    $s_gehalt = 0;;
                    $s_sozial = 0;;
                @endphp
                @foreach($data as $record)
                    @php
                        $id = $record->id;
                        $tabidx = 1;
                        $s_lohn += $record->lohn;
                        $s_gehalt += $record->gehalt;
                        $s_sozial += $record->sozial;
                    @endphp
                    <div class="p-1 bg-ctrl-tbl-blue">{{ $record->bereich->bezeichnung }}</div>
                    <div class="px-2">
                        <input {{ $tabidx == 1 ? 'autofocus' : '' }} tabindex="{{ $tabidx++ }}" type="input" name="{{ 'lohn[' .$id. ']' }}" value="{{ old('lohn.'.$id) ?? $record->lohn }}" class="p-0.5 text-sm font-mono border-[1px] border-blue-900" autocomplete="true" />
                        @error('lohn.'.$id)
                            <p class="text-red-500 text-xs font-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="px-2">
                        <input tabindex="{{ $tabidx++ }}" type="input" name="{{ 'gehalt[' .$id. ']' }}" value="{{ old('gehalt.'.$id) ?? $record->gehalt }}" class="p-0.5 text-sm font-mono border-[1px] border-blue-900" autocomplete="true" />
                        @error('gehalt.'.$id)
                            <p class="text-red-500 text-xs font-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="px-2">
                        <input tabindex="{{ $tabidx++ }}"  type="input" name="{{ 'sozialabgaben[' .$id. ']' }}" value="{{ old('sozialabgaben.'.$id) ?? $record->sozialabgaben }}" class="p-0.5 text-sm font-mono border-[1px] border-blue-900" autocomplete="true" />
                        @error('sozialabgaben.'.$id)
                            <p class="text-red-500 text-xs font-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                @endforeach

{{--                <div class="p-1 bg-ctrl-tbl-blue font-bold">Summen</div>--}}
{{--                <div class="px-2 bg-ctrl-tbl-blue font-bold">--}}
{{--                    <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">--}}
{{--                        {{ number_format(round((float) $s_lohn, 2),2, ',', '.'). "€" }}--}}
{{--                    </p>--}}
{{--                </div>--}}
{{--                <div class="px-2 bg-ctrl-tbl-blue font-bold">--}}
{{--                    <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">--}}
{{--                        {{ number_format(round((float) $s_gehalt, 2),2, ',', '.'). "€" }}--}}
{{--                    </p>--}}
{{--                </div>--}}
{{--                <div class="px-2 bg-ctrl-tbl-blue font-bold">--}}
{{--                    <p class="text-sm text-right font-mono bg-gray-200 px-2 mt-1.5">--}}
{{--                        {{ number_format(round((float) $s_sozial, 2),2, ',', '.'). "€" }}--}}
{{--                    </p>--}}

{{--                </div>--}}

            </div>
        </div>
        <x-safweb.pagesections.pagecontrol class="mt-2">
            <button type="reset"  tabindex="{{ $tabidx++ }}" class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" tabindex="{{ $tabidx++ }}" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

    @if ($errors->any())
        <div class="text-red-400">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

</x-layout>
