<x-layout>
    <x-core::pagesections.pagetitle subtitle="Lohnkosten">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
        {{--        <x-safweb.components.pagetopnav-spacer />--}}
        {{--        <span class="inline-block my-1">--}}
        {{--            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 22 22"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-circle-number-1"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /><path d="M10 10l2 -2v8" /></svg>--}}
        {{--        </span>--}}
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Lohnkosten erfassen" subtitle="für Bereiche" />

    <form method="POST" action="/mis/klr/stammdaten/lohnkosten/abt">
        @csrf
        @method('POST')

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">
            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <x-safweb.forms.input readonly name="jahr" size="10" value="{{ $jahr }}" />
                <x-safweb.forms.input readonly name="option" label="Erfassen für" size="10" value="{{ $option }}" />
            </div>
        </div>


        <!-- FORM Grid -->
        <div class="w-2/3 md:w-1/2 my-4">
            <div class="grid grid-cols-[3fr_6fr_1fr_1fr_1fr] gap-1">
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Bereich</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Abteilung</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Lohn</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Gehalt</div>
                <div class="p-1 bg-ctrl-tbl-blue font-bold">Sozialabgaben</div>

                @php
                    $tabidx=1;
                    $abt = '';
                    $abtStr = '';
                    $bg = '';
                @endphp

                @foreach($kst as $abteilung)

                    @php
                        $id=$abteilung->id;
                        $abtStr = '';
                        $bg = '';
                        if ($abt != $abteilung->bereich->bezeichnung) {
                            $abtStr = $abteilung->bereich->bezeichnung;
                            $abt = $abteilung->bereich->bezeichnung;
                            $bg = ' bg-ctrl-tbl-blue ';
                        }
                    @endphp

                    <div class="p-1 {{ $bg }} font-bold">{{ $abtStr }}</div>
                    <div class="p-1 bg-ctrl-tbl-blue text-sm">{{ $abteilung->bezeichnung }}</div>
                    <div class="px-2">
                        <input type="hidden" name="{{ 'bereich['.$abteilung->id.']' }}" value="{{ $abteilung->bereich->id }}">
                        <input {{ $tabidx == 1 ? 'autofocus' : '' }} tabindex="{{ $tabidx++ }}" type="input" name="{{ 'lohn[' .$id. ']' }}" value="{{ old('lohn.'.$id) }}" class="p-0.5 text-sm font-mono border-[1px] border-blue-900" autocomplete="true" />
                        @error('lohn.'.$id)
                            <p class="text-red-500 text-xs font-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="px-2">
                        <input tabindex="{{ $tabidx++ }}" type="input" name="{{ 'gehalt[' .$id. ']' }}" value="{{ old('gehalt.'.$id) }}" class="p-0.5 text-sm font-mono border-[1px] border-blue-900" autocomplete="true" />
                        @error('gehalt.'.$id)
                            <p class="text-red-500 text-xs font-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                    <div class="px-2">
                        <input tabindex="{{ $tabidx++ }}"  type="input" name="{{ 'sozialabgaben[' .$id. ']' }}" value="{{ old('sozialabgaben.'.$id) }}" class="p-0.5 text-sm font-mono border-[1px] border-blue-900" autocomplete="true" />
                        @error('sozialabgaben.'.$id)
                            <p class="text-red-500 text-xs font-semibold">{{ $message }}</p>
                        @enderror
                    </div>
                @endforeach

            </div>
        </div>
        <x-safweb.pagesections.pagecontrol class="mt-2">
            <button type="reset"  tabindex="{{ $tabidx++ }}" class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" tabindex="{{ $tabidx++ }}" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

</x-layout>
