<x-layout>
    <x-core::pagesections.pagetitle subtitle="Kostenträger">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis/klr/stammdaten"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Kostenträger / Produkt" subtitle=" {{ $kt->bezeichnung }} / {{ $prod->bezeichnung }}" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info name="name" size="30" value="{{ $kt->name }}" />
            <x-safweb.forms.info name="bezeichnung" cols="30" rows="4" value="{{ $kt->bezeichnung }}"/>
            <x-safweb.forms.info name="beschreibung" value="{{ $kt->beschreibung }}"/>
            <x-safweb.forms.info format="date" name="created_at" size="10" label="angelegt am" value="{{ $kt->created_at }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $kt->changed_at }}"/>

        </div>
    </div>

    <x-core::pagesections.pagesubsectiontitle>zugehörige Artikel</x-core::pagesections.pagesubsectiontitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.pagetopnav-contextbutton href="#" icon="database" label="importierte Artikel" />
        <x-safweb.components.pagetopnav-contextbutton href="#" icon="hand-sparkles" label="manuelle angelegte Artikel" />
        <x-safweb.components.pagetopnav-contextbutton href="{{route('mis.klr.stammdaten.kostentraeger.create_artikel', $prod)}}" icon="plus" label="manuell neu anlegen" />
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.table :tableDef="$tableDef" :data="$artikel"/>

</x-layout>
