<x-layout>
    <x-core::pagesections.pagetitle subtitle="Übersicht">
        Kostenstellenstruktur
    </x-core::pagesections.pagetitle>

    <!-- PageTopnav -->
    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis" />
    </x-safweb.pagesections.pagetopnav>

    <table class="mt-4">
        <thead>
            <tr>
                @foreach($kostenstellen as $idx => $kostenstelle)
                    <th class="p-4 border-2 border-blue-700 bg-cyan-300">
                        {{ $kostenstelle->bezeichnung }}
                    </th>
                @endforeach
            </tr>
        </thead>

        <tbody>
            <tr>
                @foreach($kostenstellen as $idx => $kostenstelle)
                    <td class="border-2 border-blue-200 align-top p-2">
                        <table>
                            @foreach($kostenstelle->abteilungen as $i => $abteilung)
                                <tr class="border-2 border-spacing-2 m-4">
                                    <td class="p-4">
                                        {{ $abteilung->bezeichnung }}
                                        <p class="text-xs">{{ $abteilung->beschreibung }}</p>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </td>
                @endforeach
            </tr>
        </tbody>

    </table>

</x-layout>
