<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/bilanz">
    @csrf

    <x-core::pagesections.pagetitle subtitle="Bilanzdaten">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Daten der Bilanz" subtitle="aus dem Jahr {{ $bilanz->jahr }}" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info format="year" name="jahr" size="30" value="{{ $bilanz->jahr }}" />
            <x-safweb.forms.info format="currency" name="lohn" size="30" value="{{ $bilanz->lohn }}" />
            <x-safweb.forms.info format="currency" name="sozialabgaben" cols="30" rows="4" value="{{ $bilanz->sozialabgaben }}"/>
            <x-safweb.forms.info format="currency" name="abschreibungen" size="10" label="Wert" value="{{ $bilanz->abschreibungen }}"/>
            <x-safweb.forms.info format="currency" name="aufwaende" size="10" label="Text" value="{{ $bilanz->aufwaende }}"/>
            <x-safweb.forms.info format="currency" name="zinsen" size="10" value="{{ $bilanz->zinsen }}"/>
            <x-safweb.forms.info format="currency" name="vorraete" size="10" value="{{ $bilanz->vorraete }}"/>
            <x-safweb.forms.info format="number" name="personenzahl" size="10" label="Personal" value="{{ $bilanz->personalzahl }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $bilanz->created_at }}"/>

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <a href="/mis/klr/stammdaten/bilanz/{{ $bilanz->id }}/edit" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">bearbeiten<i class="fa fa-pencil-alt ml-2"></i></a>
        <a onclick="return confirm('Diesen Satz wirklich löschen?')" href="/mis/klr/stammdaten/bilanz/{{ $bilanz->id }}/delete" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-red text-white hover:bg-red-400">löschen<i class="fa fa-trash ml-2"></i></a>
    </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
