<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/bilanz/{{ $bilanz->id }}">
    @csrf
    @method('PATCH')

    <x-core::pagesections.pagetitle subtitle="Bilanzdaten bearbeiten">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Bilanzdaten bearbeiten" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.input autofocus format="year" tabindex="1" name="jahr" size="10"  value="{{ $bilanz->jahr }}"/>
            <x-safweb.forms.input tabindex="2" name="lohn" size="20" value="{{ $bilanz->lohn }}"/>
            <x-safweb.forms.input tabindex="3" name="sozialabgaben" size="20"  value="{{ $bilanz->sozialabgaben }}"/>
            <x-safweb.forms.input tabindex="4" name="abschreibungen" size="20"  value="{{ $bilanz->abschreibungen }}"/>
            <x-safweb.forms.input tabindex="5" name="aufwaende" size="20" label="Aufwände"  value="{{ $bilanz->aufwaende }}"/>
            <x-safweb.forms.input tabindex="6" name="zinsen" size="20"  value="{{ $bilanz->zinsen }}"/>
            <x-safweb.forms.input tabindex="7" name="vorraete" size="20" label="Vorräte"  value="{{ $bilanz->vorraete }}"/>
            <x-safweb.forms.input tabindex="8" name="personalzahl" size="10" label="Personal"  value="{{ $bilanz->personalzahl }}"/>

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
        <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
    </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
