<x-layout>
    <x-core::pagesections.pagetitle subtitle="Abteilung">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-core::buttons.backlinkbutton href="/mis/klr/stammdaten/kostenstelle/{{ $abteilung->bereich->id }}" />
        <x-core::buttons.modulbutton href="/mis" />
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Daten der Abteilung" subtitle=" {{ $abteilung->bezeichnung }}" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info name="bereich" size="30" value="{{ $abteilung->abteilung }}" />
            <x-safweb.forms.info name="bezeichnung" cols="30" rows="4" value="{{ $abteilung->bezeichnung }}"/>
            <x-safweb.forms.info name="beschreibung" value="{{ $abteilung->beschreibung }}"/>
            <x-safweb.forms.info name="type" value="{{ $abteilung->typeBezeichnung }}"/>
            <x-safweb.forms.info format="number" name="personal" value="{{ $abteilung->personal }}"/>
            <x-safweb.forms.info format="date" name="created_at" size="10" label="angelegt am" value="{{ $abteilung->created_at }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $abteilung->changed_at }}"/>

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <a href="/mis/klr/stammdaten/abteilung/{{ $abteilung->id }}/edit" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">bearbeiten<i class="fa fa-pencil-alt ml-2"></i></a>
        <a onclick="return confirm('Diesen Satz wirklich löschen?')" href="/mis/klr/stammdaten/abteilung/{{ $abteilung->id }}/delete" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-red text-white hover:bg-red-400">löschen<i class="fa fa-trash ml-2"></i></a>
    </x-safweb.pagesections.pagecontrol>

</x-layout>
