<x-layout>
    <form method="POST" action="/mis/klr/stammdaten/abteilung/{{ $abteilung->id }}">
        @csrf
        @method('PATCH')

        <x-core::pagesections.pagetitle subtitle="Abteilung bearbeiten">MIS-Stammdaten</x-core::pagesections.pagetitle>

        <x-safweb.pagesections.pagetopnav>
            <x-core::buttons.backlinkbutton href="/mis/klr/stammdaten/kostenstelle/{{ $abteilung->bereich->id }}" />
            <x-core::buttons.modulbutton href="/mis" />
        </x-safweb.pagesections.pagetopnav>

        <x-safweb.forms.headline title="Abteilung bearbeiten" />

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">
            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <x-safweb.forms.input autofocus tabindex="1" name="abteilung" size="30" value="{{ $abteilung->abteilung }}"/>
                <x-safweb.forms.input tabindex="2" name="bezeichnung" size="60"  value="{{ $abteilung->bezeichnung }}"/>
                <x-safweb.forms.input tabindex="3" name="beschreibung" size="60"  value="{{ $abteilung->beschreibung }}"/>
                <x-safweb.forms.select tabindex="4" name="type" value="{{ $abteilung->type }}" :options="$options" />
                <x-safweb.forms.input tabindex="5" name="personal" size="5"  value="{{ $abteilung->personal }}"/>
            </div>
        </div>

        <x-safweb.pagesections.pagecontrol>
            <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>
</x-layout>
