<x-layout>
    <x-core::pagesections.pagetitle subtitle="Kostenstellenbereich">MIS-Stammdaten</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Daten des Kostenstellenbereich" subtitle=" {{ $kstBereich->bezeichnung }}" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info name="bereich" size="30" value="{{ $kstBereich->bereich }}" />
            <x-safweb.forms.info name="bezeichnung" cols="30" rows="4" value="{{ $kstBereich->bezeichnung }}"/>
            <x-safweb.forms.info name="beschreibung" value="{{ $kstBereich->beschreibung }}"/>
            <x-safweb.forms.info format="date" name="created_at" size="10" label="angelegt am" value="{{ $kstBereich->created_at }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $kstBereich->changed_at }}"/>

        </div>
    </div>


    <x-core::pagesections.pagesubsectiontitle>Abteilung neu anlegen</x-core::pagesections.pagesubsectiontitle>

    <form method="POST" action="/mis/klr/stammdaten/abteilung">
        @csrf
        @method('POST')

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">
            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <input type="hidden" name="bereich" value="{{ $kstBereich->id }}" />
                <x-safweb.forms.input autofocus tabindex="1" name="abteilung" size="30" />
                <x-safweb.forms.input tabindex="2" name="bezeichnung" size="60" />
                <x-safweb.forms.input tabindex="3" name="beschreibung" size="60" />
                <x-safweb.forms.select tabindex="4" name="type"  value="" :options="$options" />
                <x-safweb.forms.input tabindex="5" name="personal" size="5" />
            </div>
        </div>

        <x-safweb.pagesections.pagecontrol>
            <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
