<x-layout>
    <x-core::pagesections.pagetitle subtitle="Maschine {{ $maschine->name }} / {{ $maschine->bezeichnung }} (ID:{{ $maschine->id }})">
        Maschinendatenblatt
    </x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/mis"/>
    </x-safweb.pagesections.pagetopnav>

    <div class="grid grid-cols-1 md:grid-cols-2">
        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
            <div class="p-1 border-b-[1px] bg-ctrl-tbl-orange">
                Maschinenstammdaten
            </div>
            <div class="p-1 border-b-[1px] bg-ctrl-tbl-orange"></div>

            <x-safweb.forms.info name="name" size="30" value="{{ $maschine->name }}" />
            <x-safweb.forms.info name="bezeichnung" size="30" value="{{ $maschine->bezeichnung }}" />
            <x-safweb.forms.info name="beschreibung" cols="30" rows="4" value="{{ $maschine->beschreibung }}"/>
            <x-safweb.forms.info format="currency" name="anschaffungswert" size="10" label="Anschaffungswert in €" value="{{ $maschine->anschaffungswert }}"/>
            <x-safweb.forms.info format="currency" name="restbuchwert" size="10" label="Restbuchwert in €" value="{{ $maschine->restbuchwert }}"/>
            <x-safweb.forms.info format="currency" name="wiederbeschaffungswert" size="10" label="Wiederbeschaffungswert in €" value="{{ $maschine->wiederbeschaffungswert }}"/>
            <x-safweb.forms.info format="year" name="beschaffungsjahr" size="10" value="{{ $maschine->beschaffungsjahr }}"/>
            <x-safweb.forms.info name="nutzungsdauer" size="10" label="Nutzungsdauer (Jahre)" value="{{ $maschine->nutzungsdauer }}"/>
            <x-safweb.forms.info name="raumbedarf" size="10" label="Raumbedarf (m<sup>2</sup>)" value="{{ $maschine->raumbedarf }}"/>
            <x-safweb.forms.info name="anschlussleistung" size="10" label="Anschlussleistung (kw)" value="{{ $maschine->anschlussleistung }}"/>
            <x-safweb.forms.info format="number" name="kapazitaet_jahr" size="10" label="Kapazität (pro Jahr)" value="{{ $maschine->kapazitaet_jahr }}"/>
            <x-safweb.forms.info format="number" name="kapazitaet_minute" size="10" label="Kapazität (pro Minute)" value="{{ $maschine->kapazitaet_minute }}"/>
            <x-safweb.forms.info format="currency" name="betriebskosten" size="10" label="Betriebskosten in €" value="{{ $maschine->betriebskosten }}"/>
            <x-safweb.forms.info format="currency" name="instandhaltungskosten" size="10" label="Instandhaltungskosten in €" value="{{ $maschine->instandhaltungskosten }}"/>
            <x-safweb.forms.info format="number,2" name="ms_faktor" size="10" label="MS Faktor" value="{{ $maschine->ms_faktor }}"/>
            <x-safweb.forms.info name="faktor_beschreibung" size="10" label="MS Faktor Beschreibung" value="{{ $maschine->faktor_beschreibung }}"/>
            <x-safweb.forms.info format="date" name="created_at" size="10" label="angelegt am" value="{{ $maschine->created_at }}"/>
            <x-safweb.forms.info format="date" name="changed_at" size="10" label="geändert am" value="{{ $maschine->changed_at }}"/>
        </div>

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
            <div class="p-1 border-b-[1px] bg-ctrl-tbl-orange">
                aktuelle Kalkulationsdaten
            </div>
            <div class="p-1 border-b-[1px] bg-ctrl-tbl-orange">
                ({{ date_format(date_create($stundensatz->created_at),'d.m.Y') }})
            </div>

            <x-safweb.forms.info format="currency" name="kalkulatorische Abschreibung" size="30" value="{{ $stundensatz->abschreibung_k }}" />
            <x-safweb.forms.info format="currency" name="Abschreibung pro Stunde" size="30" value="{{ $stundensatz->abschreibung_h }}" />
            <x-safweb.forms.info format="currency" name="Raumkosten pro Stunde" size="30" value="{{ $stundensatz->raumkosten_h }}" />
            <x-safweb.forms.info format="currency" name="Energiekosten pro Stunde" size="30" value="{{ $stundensatz->energie_h }}" />
            <x-safweb.forms.info format="currency" name="Betriebskosten pro Stunde" size="30" value="{{ $stundensatz->betrieb_h }}" />
            <x-safweb.forms.info format="percent" name="Auslastung A" size="30" value="{{ $stundensatz->auslastung_a }}" />
            <x-safweb.forms.info format="currency" name="Stundensatz A" size="30" value="{{ $stundensatz->summe_a }}" />
            <x-safweb.forms.info format="currency,5" name="Stückkosten A" size="30" value="{{ $stundensatz->stueck_a }}" />
            <x-safweb.forms.info format="number,5" name="MS-Faktor A" size="30" value="{{ $stundensatz->faktor_a }}" />
            <x-safweb.forms.info format="percent" name="Auslastung B" size="30" value="{{ $stundensatz->auslastung_b }}" />
            <x-safweb.forms.info format="currency" name="Stundensatz B" size="30" value="{{ $stundensatz->summe_b }}" />
            <x-safweb.forms.info format="currency,5" name="Stückkosten B" size="30" value="{{ $stundensatz->stueck_b }}" />
            <x-safweb.forms.info format="number,5" name="MS-Faktor B" size="30" value="{{ $stundensatz->faktor_b }}" />
            <x-safweb.forms.info format="percent" name="Auslastung C" size="30" value="{{ $stundensatz->auslastung_c }}" />
            <x-safweb.forms.info format="currency" name="Stundensatz C" size="30" value="{{ $stundensatz->summe_c }}" />
            <x-safweb.forms.info format="currency,5" name="Stückkosten C" size="30" value="{{ $stundensatz->stueck_c }}" />
            <x-safweb.forms.info format="number,5" name="MS-Faktor c" size="30" value="{{ $stundensatz->faktor_c }}" />

        </div>
    </div>

</x-layout>
