<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_lohnkosten', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->unsignedBigInteger('bikr_kst_bereiche_id');
            $table->unsignedBigInteger('bikr_kst_abteilungen_id')->nullable();
            $table->float('lohn')->nullable();
            $table->float('gehalt')->nullable();
            $table->float('sozialabgaben')->nullable();
            $table->integer('jahr');

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrLohnkostenSeeder',
            '--force' => true // <--- add this line
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_lohnkosten');
    }
};
