<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_produktlinie_stationen', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->unsignedBigInteger('bikr_produktlinien_id');
            $table->unsignedBigInteger('bikr_maschinendaten_id')->nullable();
            $table->string('name', 30);
            $table->string('beschreibung')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrProduktlinieStationenSeeder',
            '--force' => true // <--- add this line
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_produktlinie_stationen');
    }
};
