<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_kt_artikel', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->unsignedBigInteger('bikr_kt_produkte_id');
            $table->string('teilenummer', 30);
            $table->string('bezeichnung', 60)->nullable();
            $table->string('beschreibung')->nullable();
            $table->string('beschaffungsart')->nullable();            // Zukauf, Frendfertigung, Eigenfertigung
            $table->unsignedInteger('erfassung')->default(0);   // 0: SQL Select, 1: manuell
            $table->string('referenz')->nullable();                   // db.schema.table.field
            $table->string('ref_primary_key')->nullable();            // Wert fuer refenz in FremdDB (ID, Pkey)

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrKtArtikelSeeder',
            '--force' => true // <--- add this line
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_kt_artikel');
    }
};
