<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_kt_produkte', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->unsignedBigInteger('bikr_kt_gruppen_id');
            $table->string('name', 30);
            $table->string('bezeichnung', 60)->nullable();
            $table->string('beschreibung')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrKtProdukteSeeder',
            '--force' => true // <--- add this line
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_kt_produkte');
    }
};
