<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_kst_abteilungen', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->unsignedBigInteger('bikr_kst_bereiche_id');
            $table->string('abteilung', 30);
            $table->string('bezeichnung', 60)->nullable();
            $table->string('beschreibung')->nullable();
            $table->string('type', 2);                      // k: KST  h:HilfsKST
            $table->integer('personal')->default(0);         // Anzahl Personal

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrKstAbteilungenSeeder',
            '--force' => true // <--- add this line
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_kst_abteilungen');
    }
};
