<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_bilanzen', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->integer('jahr')->unsigned();
            $table->float('lohn')->nullable();              // Löhne und Gehälter
            $table->float('sozialabgaben')->nullable();     // Sozialabgaben
            $table->float('abschreibungen')->nullable();    // Abschreibungen
            $table->float('aufwaende')->nullable();         //
            $table->float('zinsen')->nullable();            //

            $table->float('vorraete')->nullable();          //
            $table->integer('personalzahl')->nullable();    // Anzahl der Angestellten

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrBilanzSeeder',
            '--force' => true // <--- add this line
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_bilanzen');
    }
};
