<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_maschinenstundensaetze', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->bigInteger('maschine_id')->unsigned();
            $table->float('abschreibung_k')->nullable();        // kalkulatorische Abschreibung
            $table->float('abschreibung_h')->nullable();        // Abschreibung pro Stunde
            $table->float('raumkosten_h')->nullable();          // Raumkosten pro Stunde
            $table->float('energie_h')->nullable();             // Energiekosten pro Stunde
            $table->float('betrieb_h')->nullable();             // Betriebskosten pro Stunde

            $table->float('auslastung_a')->nullable();          // 1. Auslastung (100%)
            $table->float('summe_a')->nullable();               // Summe bei Auslastung 1
            $table->float('stueck_a')->nullable();              // Stckkosten bei Auslastung 1
            $table->float('faktorwert_a')->nullable();          // wenn ms_faktor gesetzt, dann statt stundensatz verwenden

            $table->float('auslastung_b')->nullable();          // 2. Auslastung (75%)
            $table->float('summe_b')->nullable();               // Summe bei Auslastung 2
            $table->float('stueck_b')->nullable();              // Stckkosten bei Auslastung 1
            $table->float('faktorwert_b')->nullable();          // wenn ms_faktor gesetzt, dann statt stundensatz verwenden

            $table->float('auslastung_c')->nullable();          // 3. Auslastung (50%)
            $table->float('summe_c')->nullable();               // Summe bei Auslastung 3
            $table->float('stueck_c')->nullable();              // Stckkosten bei Auslastung 1
            $table->float('faktorwert_c')->nullable();          // wenn ms_faktor gesetzt, dann statt stundensatz verwenden

            $table->unsignedInteger('gueltig_ab')->nullable();  // yyyymmdd
            $table->unsignedInteger('aktiv')->default(1); // 0|1

            $table->timestamps();
            $table->softDeletes();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_maschinenstundensaetze');
    }
};
