<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_parameter', function (Blueprint $table) {
            $table->id()->autoIncrement();

            $table->string('name');
            $table->string('bezeichnung');
            $table->string('beschreibung')->nullable();
            $table->float('value_numeric')->nullable();
            $table->string('value_string')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_parameter');
    }
};
