<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bikr_maschinendaten', function (Blueprint $table) {
            $table->id()->autoIncrement();
            $table->string('name');
            $table->string('bezeichnung')->nullable();
            $table->string('beschreibung')->nullable();
            $table->float('anschaffungswert');
            $table->float('restbuchwert');
            $table->float('wiederbeschaffungswert');
            $table->unsignedInteger('beschaffungsjahr')->nullable();
            $table->unsignedInteger('nutzungsdauer');
            $table->float('raumbedarf');
            $table->float('anschlussleistung');
            $table->unsignedBigInteger('kapazitaet_jahr');                // Ausstoss pro Jahr
            $table->unsignedInteger('kapazitaet_minute');                 // Ausstoss pro Minute
            $table->float('betriebskosten');                              // pro Jahr
            $table->float('instandhaltungskosten');                       // pro Jahr

            /**
             * ms_faktor ist ein Wert der statt des Maschinenstundesnsatzes MS verwendet wird.
             * Da kommt zum Tragen, wenn der Preis für die Maschine nicht vom Stundensatz abgeleitet werden
             * soll, sondern je Produkt (per Gewicht) ermittet wird.
             * Ein Beispiel ist eine Waschmaschine, die x kg vom Produkt in y Zeit waschen kann. Mit dem
             * Produktgewicht und der Waschzeit variiert dann der Preis.
             * Der Maschinenstundensatz wird dann mit dem Faktor multipliziert.
             * Beispielformel:
             *  Preis_jeStck = BG * ( (MS * 60 Minuten) / (50kg * 15Minuten) )
             *  => Faktor = 0,08 * MS = 1,452
             *  => BG = Bruttogewicht Produkt * Faktor
             */
            $table->float('ms_faktor')->nullable()->default(null);  // Faktor auf Maschinenstundensatz
            $table->string('faktor_beschreibung')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });

        Artisan::call('db:seed', [
            '--class' => 'BikrMaschinendatenSeeder',
            '--force' => true // <--- add this line
        ]);

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bikr_maschinendaten');
    }
};
