# MIS Datenbankschema

MIS benötigt Datenspeicher neben den Quelldaten aus dem angebundenen System.
Insbesondere das Modul KLR benötigt einige Metadaten um die Berechnungen 
durchzuführen.


## Datenspeicher Tabellen

```
Semantik: 
BI - Business Intelligence
KR - Kosten- und Leistungsrechnung

Tabellen:
Maschinendaten      bikr_maschinendaten         CRUD OK
Kalkparameter       bikr_kalkparameter          CRUD OK
Kostenstellen       
                    bikr_kst_bereiche           CRUD OK
                    bikr_kst_abteilungen        CRUD OK
                       
Kostenträger        
                    bikr_kt_gruppen             CRUD OK
                    bikr_kt_produkte            CRUD
                    bikr_kt_artikel             CRUD
                    
BAB-Struktur        bikr_bab_struktur
Bilanzwerte         bikr_bilanzen               CRUD OK
Lohnkosten          bikr_lohnkosten            
Kalkschema          bikr_kalkschemata

Materialaufwendungen
    Verpackung      bikr_verpackungsmaterial     
    Betriebsstoffe  bikr_betriebsstoffe  
    Rohstoffe       bikr_rohstoffe       
    Hilfsstoffe     bikr_hilfsstoffe     

Berechnen:
Maschinenstundensatz                            OK


```


## Datenschema
``` 
Bilanzwerte

OK  bikr_bilanz
        ID
        jahr
        lohn
        sozialabgaben
        abschreibungen
        aufwände
        zinsen
        vorräte
        personalzahl
    

Kostenstellen / Kostenstellenstruktur

bikr_kst_bereiche       <- bikr_kst_abteilungen
    ID
    bereich
    bezeichnung
    beschreibung

bikr_kst_abteilungen
    ID
    bikr_kst_bereiche.id    -> bikr_kst_bereiche
    bezeichnung
    beschreibung
    kst_typ     | hkst, kst
    personal
    
bikr_kostentraeger      <- bikr_kostentraeger_artikel
    ID
    name
    bezeichnung
    bezug           // eigen, fremd, zukauf

bikr_kostentraeger_artikel
    ID
    bikr_kostentraeger.id
    artikelnummer
    bezeichnung
    warenart
    produktgruppe
    
bikr_kostenarten
    ID
    name
    bezeichnung
    quelle
    referenz (table.field.value)

bikr_produktlinien
    ID
    name
    bezeichnung
    beschreibung

bikr_produktlinienstationen
    ID
    bikr_produktlinien.id
    maschine.id
    name
    beschreibung
    bezeichnung
    prozessfaktor


bikr_kalkschema
    ID
    name
    beschreibung

bikr_kalkschema_steps
    ID
    bikr_kalkschema.id
    name
    bezeichnung
    referenz

    // n:m
    bikr_kalkschema_steps_formeln
        ID
        bikr_kalkschema_steps.id
        bikr_formelsammlung.id

bikr_formelsammlung
    ID 
    name
    bezeichnung
    beschreibung
    formel
```
