<?php

namespace App\modules\Mis\database\factories;

use App\modules\Mis\Models\BikrMaschinendaten;
use App\modules\Mis\Models\BikrParameter;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class BikrParameterFactory extends Factory
{

    /** IMPORTANT  */
    protected $model = BikrParameter::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->name(),
            'bezeichnung' => fake()->company(),
            'beschreibung' => fake()->text(30),
            'value_numeric' => fake()->randomFloat(2, 0, 1000),
            'value_string' => '',
        ];
    }
}
