<?php

namespace App\modules\Mis\database\factories;

use App\modules\Mis\Models\BikrMaschinendaten;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class BikrMaschinendatenFactory extends Factory
{

    /** IMPORTANT  */
    protected $model = BikrMaschinendaten::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->name(),
            'bezeichnung' => fake()->company(),
            'beschreibung' => fake()->text(100),
            'anschaffungswert' => fake()->numberBetween(80000,350000),
            'restbuchwert' => fake()->numberBetween(5000,1000),
            'wiederbeschaffungswert' => fake()->numberBetween(100000,450000),
            'beschaffungsjahr' => fake()->numberBetween(2000,2025),
            'nutzungsdauer' => fake()->numberBetween(10,30),
            'raumbedarf' => fake()->numberBetween(10, 25),
            'anschlussleistung' => fake()->numberBetween(2,35),
            'kapazitaet_jahr' => fake()->numberBetween(100000,1000000),
            'kapazitaet_minute' => fake()->numberBetween(10,300),
            'betriebskosten' => fake()->numberBetween(8000,12000),
            'instandhaltungskosten' => fake()->numberBetween(12000,24000),
        ];
    }
}
