<?php

return [
    'name' => 'MIS',
    'title' => 'MIS',
    'subtitle' => 'Management Information System',
    'namespace' => 'App\Modules\Mis',
    'version' => '1.0.0',
    'navigation' => [
        'meta' => [
            'name' => 'MIS',
            'desc' => 'Management Information System',
            'link' => '/mis',
            'permission' => true,
            'icon' => 'fa-chart-line'
        ],
        'functions' => [
            'stat' => [
                'meta' => [
                    'name' => 'Auswertungen',
                    'desc' => 'Statistische Auswertungen für den Einkauf/Verkauf und Bestandsentwicklungen.',
                    'link' => '/mis/stat',
                    'permission' => true,
                    'icon' => 'fa-chart-bar',
                ],
                'functions' => [
                    'ek' => [
                        'meta' => [
                            'name' => 'Einkauf',
                            'desc' => 'Statistische Daten der Beschaffung',
                            'link' => '/mis/stat/ek',
                            'permission' => true,
                            'icon' => 'fa-shopping-cart',
                            'disabled' => false,
                        ],
                        'functions' => [
                            'lieferanten' => [
                                'meta' => [
                                    'name' => 'Lieferanten',
                                    'desc' => 'Auswertungen der Bestellungen',
                                    'link' => '/mis/stat/ek/lieferant',
                                    'permission' => true,
                                    'icon' => 'fa-user',
                                ],
                                'functions' => []
                            ],
                            'artikel' => [
                                'meta' => [
                                    'name' => 'Artikel',
                                    'desc' => 'Auswertungen über beschaffte Artikel',
                                    'link' => '/mis/stat/ek/artikel',
                                    'permission' => true,
                                    'icon' => 'fa-boxes',
                                    'disabled' => true,
                                ],
                                'functions' => []
                            ],
                        ]
                    ],
                    'vk' => [
                        'meta' => [
                            'name' => 'Verkauf',
                            'desc' => 'Verkauf',
                            'link' => '/mis/stat/vk',
                            'permission' => true,
                            'icon' => 'fa-truck'
                        ],
                        'functions' => [
                            'rgjournal' => [
                                'meta' => [
                                    'name' => 'Rechnungsjournal',
                                    'desc' => 'Liste der erstellten Rechnungen im Zeitraum',
                                    'link' => '/mis/stat/vk/rgjournal',
                                    'permission' => true,
                                    'icon' => 'fa-file-invoice'
                                ]
                            ],
                            'kunden' => [
                                'meta' => [
                                    'name' => 'Kunden',
                                    'desc' => 'Auswertungen zu Kunden',
                                    'link' => '/mis/stat/vk/kunden',
                                    'permission' => true,
                                    'icon' => 'fa-box-open'
                                ]
                            ]
                        ]
                    ],
                    'bestand' => [
                        'meta' => [
                            'name' => 'Bestand',
                            'desc' => 'Bestand',
                            'link' => '/mis/stat/bestand',
                            'permission' => true,
                            'icon' => 'fa-warehouse',
                            'disabled' => true,
                        ],
                        'functions' => []
                    ],

                ]
            ],
            'klr' => [
                'meta' => [
                    'name' => 'KLR',
                    'desc' => 'Kosten- und Leistungsrechnung. Kalkulationen.',
                    'link' => '/mis/klr',
                    'permission' => true,
                    'icon' => 'fa-percent'
                ],
                'functions' => [
                    'stammdaten' => [
                        'meta' => [
                            'name' => 'Stammdaten',
                            'desc' => 'Pflege der Basisdaten für die Kalkulationen',
                            'link' => '/mis/klr/stammdaten',
                            'permission' => true,
                            'icon' => 'fa-table'
                        ],
                        'functions' => [
                            'bilanzdaten' => [
                                'meta' => [
                                    'name' => 'Bilanzdaten',
                                    'desc' => 'Daten aus den jährlichen Bilanzen erfassen',
                                    'link' => '/mis/klr/stammdaten/bilanz',
                                    'permission' => true,
                                    'icon' => 'fa-book'
                                ]
                            ],
                            'lohndaten' => [
                                'meta' => [
                                    'name' => 'Lohndaten',
                                    'desc' => 'Lohnkosten den Abteilungen zuordnen',
                                    'link' => '/mis/klr/stammdaten/lohnkosten',
                                    'permission' => true,
                                    'icon' => 'fa-euro-sign'
                                ]
                            ],
                            'maschinen' => [
                                'meta' => [
                                    'name' => 'Maschinen',
                                    'desc' => 'Basisdaten der Maschinen zur Berechnung der Maschinenstundensätze',
                                    'link' => '/mis/klr/stammdaten/maschine',
                                    'permission' => true,
                                    'icon' => 'fa-industry'
                                ]
                            ],
                            'faline' => [
                                'meta' => [
                                    'name' => 'Fertigungslinien',
                                    'link' => '',
                                ]
                            ],
                            'kst' => [
                                'meta' => [
                                    'name' => 'Kostenstellen',
                                    'desc' => 'Struktur aller Kostenstellen im Unternehmen',
                                    'link' => '/mis/klr/stammdaten/kostenstelle',
                                    'permission' => true,
                                    'icon' => 'fa-sitemap'
                                ]
                            ],
                            'kostentraeger' => [
                                'meta' => [
                                    'name' => 'Kostenträger',
                                    'desc' => 'Erlösquellen des Unternehmens',
                                    'link' => '/mis/klr/stammdaten/kostentraeger',
                                    'permission' => true,
                                    'icon' => 'fa-hand-holding-usd'
                                ]
                            ],
                            'babstruk' => [
                                'meta' => [
                                    'name' => 'BAB Struktur',
                                    'link' => '',
                                ]
                            ],
                            'parameter' => [
                                'meta' => [
                                    'name' => 'Parameter',
                                    'desc' => 'Berechnungsparameter: Stunden pro Jahr, Raumkostensatz, Energiekostensatz, usw. ',
                                    'link' => '/mis/klr/stammdaten/parameter',
                                    'permission' => true,
                                    'icon' => 'fa-calculator'
                                ]
                            ],
                        ]
                    ],
                    'maschinenkalkulation' => [
                        'meta' => [
                            'name' => 'Maschinenkalkulation',
                            'desc' => 'Kalkulation der Maschinenstundensätze',
                            'link' => '/mis/klr/maschinenkalkulation',
                            'permission' => true,
                            'icon' => 'fa-industry'
                        ],
                        'functions' => [
                            'datenblatt' => [
                                'meta' => [
                                    'name' => 'Datenblatt',
                                    'desc' => 'Maschinendatenblatt anzeigen',
                                    'link' => '/mis/klr/maschinenkalkulation/datenblatt',
                                    'permission' => true,
                                    'icon' => 'fa-file-alt'
                                ],
                            ],
                            'berechnen' => [
                                'meta' => [
                                    'name' => 'Berechnen',
                                    'desc' => 'Maschinenstundensätze berechnen',
                                    'link' => '',
                                ],
                            ],
                            'kosten' => [
                                'meta' => [
                                    'name' => 'Kosten',
                                    'desc' => 'Maschinenkosten erfassen',
                                    'link' => '',
                                ],
                            ],
                        ],
                    ],
                    'produktlinienkalkulation' => [
                        'meta' => [
                            'name' => 'Produktkosten',
                            'desc' => 'Produktkosten bestimmen',
                            'link' => '/mis/klr/produktkosten',
                            'permission' => true,
                            'icon' => 'fa-hammer'
                        ],
                        'functions' => []
                    ],
                    'aufschlagskalkulation' => [
                        'meta' => [
                            'name' => 'Aufschlagskalkulation',
                            'desc' => 'Aufschlagskalkulation',
                            'link' => '/mis/klr/aufschlagskalkulation',
                            'permission' => true,
                            'icon' => 'fa-calculator'
                        ],
                        'functions' => [
                            'schema' => [
                                'meta' => [
                                    'name' => 'Schemapflege',
                                    'desc' => 'Festlegen der Aufschlagsschemata je Kostenträger',
                                ],
                            ]
                        ]
                    ],
                    'rentabilitaet' => [
                        'meta' => [
                            'name' => 'Rentabilität',
                            'desc' => 'Rentabilität',
                            'link' => '/mis/klr/rentabilitaet',
                            'permission' => true,
                            'icon' => 'fa-euro-sign'
                        ],
                        'functions' => []
                    ]
                ],
            ],
            'fplan' => [
                'meta' => [
                    'name' => 'Finanzplanung',
                    'desc' => 'Bestell-Umsatzauswertung',
                    'link' => '/mis/plan',
                    'permission' => true,
                    'icon' => 'fa-euro-sign',
                    'disabled' => true
                ],
                'functions' => [],
            ],
        ],
    ],
    'models' => [
        'BikrBilanz' => ['modul' => 'mis.klr'],
        'BikrKstAbteilung' => ['modul' => 'mis.klr'],
        'BikrKstBereich' => ['modul' => 'mis.klr'],
        'BikrKtArtikel' => ['modul' => 'mis.klr'],
        'BikrKtGruppen' => ['modul' => 'mis.klr'],
        'BikrKtProdukte' => ['modul' => 'mis.klr'],
        'BikrLohnkosten' => ['modul' => 'mis.klr'],
        'BikrMaschinendaten' => ['modul' => 'mis.klr'],
        'BikrMaschinenstundensaetze' => ['modul' => 'mis.klr'],
        'BikrParameter' => ['modul' => 'mis.klr'],
        'BikrProduktlinie' => ['modul' => 'mis.klr'],
        'BikrProduktlinieStation' => ['modul' => 'mis.klr'],
    ]
];
