<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrParameterFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrParameter extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bikr_parameter';
    protected $guarded = ['id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrParameterFactory::new();
    }






    /**
     * Columns Setup for different visualisations
     */

    public static function indexColumnSettings(): array
    {
        return [
            'header' => [
                'id' => 'ID',
                'name' => 'Name',
                'bezeichnung' => 'Bez',
                'value_numeric' => 'Wert',
                'value_string' => 'Text',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'name' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/parameter'],
                'bezeichnung' => ['type' => 'string'],
                'value_numeric' => ['type' => 'float'],
                'value_string' => ['type' => 'string'],
            ],
        ];
    }

    public static function createColumnSettings():array
    {
        return [
            'header' => [
                'name' => 'Name',
                'bezeichnung' => 'Bez',
                'value_numeric' => 'Wert',
                'value_string' => 'Text',
            ],
            'columns' => [
                'name' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/parameter'],
                'bezeichnung' => ['type' => 'string'],
                'value_numeric' => ['type' => 'float'],
                'value_string' => ['type' => 'string'],
            ],
        ];
    }


}
