<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrMaschinenstundensaetzeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrMaschinenstundensaetze extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bikr_maschinenstundensaetze';
    protected $guarded = ['id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrMaschinenstundensaetzeFactory::new();
    }

    public function maschine(): BelongsTo
    {
        return $this->belongsTo(BikrMaschinendaten::class);
    }


    public static function allHourlyRatesColumns():array
    {
        return [
            'header' => [
                'maschine.name' => 'Name',
                'maschine.bezeichnung' => 'Bezeichnung',
                'abschreibung_k' => 'kalk. Abschr.',
                'abschreibung_h' => 'Abschr./h',
                'raumkosten_h' => 'Raumk./h',
                'energie_h' => 'Energiek./h',
                'betrieb_h' => 'Betr.k./h',
                'auslastung_a' => 'Auslastung A',
                'summe_a' => 'Std-Satz A',
                'stueck_a' => 'Stck.k. A',
                'auslastung_b' => 'Auslastung B',
                'summe_b' => 'Std-Satz B',
                'stueck_b' => 'Stck.k. B',
                'auslastung_c' => 'Auslastung C',
                'summe_c' => 'Std-Satz C',
                'stueck_c' => 'Stck.k. C',
            ],
            'columns' => [
                'maschine.name' => ['type' => 'string', 'sub' => 'name', 'fneditsub' => '/mis/klr/maschinenkalkulation/datenblatt'],
                'maschine.bezeichnung' => ['type' => 'string', 'sub' => 'bezeichnung'],
                'abschreibung_k' => ['type' => 'currency'],
                'abschreibung_h' => ['type' => 'currency'],
                'raumkosten_h' => ['type' => 'currency'],
                'energie_h' => ['type' => 'currency'],
                'betrieb_h' => ['type' => 'currency'],
                'auslastung_a' => ['type' => 'percent'],
                'summe_a' => ['type' => 'currency'],
                'stueck_a' => ['type' => 'currency,5'],
                'auslastung_b' => ['type' => 'percent'],
                'summe_b' => ['type' => 'currency'],
                'stueck_b' => ['type' => 'currency,5'],
                'auslastung_c' => ['type' => 'percent'],
                'summe_c' => ['type' => 'currency'],
                'stueck_c' => ['type' => 'currency,5'],
            ],
        ];
    }
}
