<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrMaschinendatenFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrMaschinendaten extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'bikr_maschinendaten';
    protected $guarded = ['id'];
    //protected $appends = ['aktuellerStundensatz'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrMaschinendatenFactory::new();
    }

    public function stundensaetze(): HasMany
    {
        return $this
            ->hasMany(BikrMaschinenstundensaetze::class, 'maschine_id', 'id')
            ->where('aktiv', '=', 1)
            ->orderBy('gueltig_ab', 'desc');
    }

    public function stundensatz(): HasOne
    {
        return $this
            ->hasOne(BikrMaschinenstundensaetze::class, 'maschine_id', 'id')
            ->where('aktiv', '=', 1)
            ->orderBy('gueltig_ab', 'desc');
    }

    public function getAktuellerStundensatzAttribute()
    {
        $calc = $this->stundensaetze()->first();
        $lastCalc = '--';
        if ($calc) {
            $lastCalc = $calc->gueltig_ab;
        }
        return $lastCalc;
    }

    /**
     * Columns Setup for different visualisations
     */

    public static function indexColumnSettings(): array
    {
        return [
            'header' => [
                'id' => 'ID',
                'name' => 'Name',
                'bezeichnung' => 'Bez',
                'beschaffungsjahr' => 'Jahr',
                'nutzungsdauer' => 'Nutzung',
                'raumbedarf' => 'Raum',
                'anschlussleistung' => 'KW',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'name' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/maschine'],
                'bezeichnung' => ['type' => 'string'],
                'beschaffungsjahr' => ['type' => 'year'],
                'nutzungsdauer' => ['type' => 'number'],
                'raumbedarf' => ['type' => 'number'],
                'anschlussleistung' => ['type' => 'number'],
            ],
        ];
    }

    public static function selectColumnSettings(): array
    {
        return [
            'header' => [
                'id' => 'ID',
                'name' => 'Name',
                'bezeichnung' => 'Bez',
                'beschaffungsjahr' => 'Jahr',
                'stundensatz' => 'letzte Berechnung',
                '_calc' => 'berechnen',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'name' => ['type' => 'string', 'fnedit_if_sub' => '/mis/klr/maschinenkalkulation/datenblatt', 'if_sub_key' => 'stundensatz'],
                'bezeichnung' => ['type' => 'string'],
                'beschaffungsjahr' => ['type' => 'year'],
                'stundensatz' => ['type' => 'date', 'sub' => 'gueltig_ab'],
                '_calc' => ['btnfn' => '/mis/klr/maschinenkalkulation/berechnen', 'icon' => 'calculator'],
            ],
        ];
    }

    public static function createColumnSettings()
    {
        return [
            'header' => [
                'name' => 'Name',
                'bezeichnung' => 'Bezeichnung',
                'beschreibung' => 'Beschreibung',
                'anschaffungswert' => 'Anschaffungswert',
                'restbuchwert' => 'Restbuchwert',
                'wiederbeschaffungswert' => 'Wiederbeschaffungswert',
                'beschaffungsjahr' => 'Beschaffungsjahr',
                'nutzungsdauer' => 'Nutzungsdauer',
                'raumbedarf' => 'Raumbedarf',
                'anschlussleistung' => 'Anschlussleistung',
                'kapazitaet_jahr' => 'Kapazitaet Jahr',
                'kapazitaet_minute' => 'Kapazitaet Minute',
                'betriebskosten' => 'Betriebskosten',
                'instandhaltungskosten' => 'Instandhaltungskosten',
             ],
            'columns' => [
                'name' => ['type' => 'string'],
                'bezeichnung' => ['type' => 'string'],
                'beschreibung' => ['type' => 'text'],
                'anschaffungswert' => ['type' => 'currency'],
                'restbuchwert' => ['type' => 'currency'],
                'wiederbeschaffungswert' => ['type' => 'currency'],
                'beschaffungsjahr' => ['type' => 'number'],
                'nutzungsdauer' => ['type' => 'number'],
                'raumbedarf' => ['type' => 'number'],
                'anschlussleistung' => ['type' => 'number'],
                'kapazitaet_jahr' => ['type' => 'number'],
                'kapazitaet_minute' => ['type' => 'number'],
                'betriebskosten' => ['type' => 'currency'],
                'instandhaltungskosten' => ['type' => 'currency'],
            ],
        ];
    }

}
