<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrLohnkostenFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrLohnkosten extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'bikr_lohnkosten';
    protected $guarded = ['id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrLohnkostenFactory::new();
    }

    public function bereich(): BelongsTo
    {
        return $this->belongsTo(BikrKstBereich::class, 'bikr_kst_bereiche_id');
    }

    public function abteilung(): BelongsTo
    {
        return $this->belongsTo(BikrKstAbteilung::class, 'bikr_kst_abteilungen_id');
    }

    public static function yearOverview()
    {
        return BikrLohnkosten::select(
            \DB::raw('min(id) as id'),
            \DB::raw('sum(lohn) as lohn'),
            \DB::raw('sum(gehalt) as gehalt'),
            \DB::raw('sum(sozialabgaben) as sozialabgaben'),
            \DB::raw('min(jahr) as jahr')
        )
            ->groupBy('jahr')
            ->orderBy('jahr')
            ->get();
    }

    public static function indexColumnSettings(): array
    {
        return [
            'header' => [
                'id' => 'ID',
                'lohn' => 'Lohn',
                'gehalt' => 'Gehalt',
                'sozialabgaben' => 'Sozialabgaben',
                'jahr' => 'Jahr',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'lohn' => ['type' => 'currency'],
                'gehalt' => ['type' => 'currency'],
                'sozialabgaben' => ['type' => 'currency'],
                'jahr' => ['type' => 'year', 'fnedit' => '/mis/klr/stammdaten/lohnkosten/jahr'],
            ],
        ];
    }

}
