<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrKtProdukteFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrKtProdukte extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bikr_kt_produkte';
    protected $guarded = ['id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrKtProdukteFactory::new();
    }

    public function arikel(): HasMany
    {
        return $this->hasMany(BikrKtArtikel::class, 'bikr_kt_produkten_id', 'id');
    }


    public static function indexColumnSetting()
    {
        return [
            'meta' => [],
            'header' => [
                'id' => 'ID',
                'name' => 'Name',
                'bezeichnung' => 'Bezeichnung',
                'beschreibung' => 'Beschreibung',
                'created_at' => 'angelegt am',
                'changed_at' => 'geändert am',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'name' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/kostentraeger/produkt'],
                'bezeichnung' => ['type' => 'string'],
                'beschreibung' => ['type' => 'string'],
                'created_at' => ['type' => 'date'],
                'changed_at' => ['type' => 'date'],
            ],
        ];
    }


}
