<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrKstBereichFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrKstBereich extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bikr_kst_bereiche';
    protected $guarded = ['id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrKstBereichFactory::new();
    }


    public function abteilungen(): HasMany
    {
        return $this->hasMany(BikrKstAbteilung::class, 'bikr_kst_bereiche_id');
    }


    public static function indexColumnSetting(): array
    {
        return [
            'meta' => [],
            'header' => [
                'id' => 'ID',
                'bereich' => 'Bereich',
                'bezeichnung' => 'Bezeichnung',
                'beschreibung' => 'Beschreibung',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'bereich' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/kostenstelle'],
                'bezeichnung' => ['type' => 'string'],
                'beschreibung' => ['type' => 'string'],
            ]
        ];
    }
}
